/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.actor;

import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.pde.internal.model.EditableFeatureModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.pde.internal.core.ifeature.IFeature;

public class OwnerVersionExtractor
extends AbstractActor {
    public static final String ID = "ownerVersionExtractor";

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        CSpec bundle = ctx.getAction().getCSpec();
        for (CSpec cspec : ctx.getAllFoundCSpecs()) {
            Version v;
            IPath location;
            if (!"eclipse.feature".equals(cspec.getComponentTypeID()) || (location = cspec.getComponentLocation()) == null || !location.hasTrailingSeparator()) continue;
            boolean found = false;
            for (ComponentRequest dep : cspec.getDependencies()) {
                if (!dep.designates((IComponentIdentifier)bundle.getComponentIdentifier())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            EditableFeatureModel featureModel = new EditableFeatureModel(location.append("feature.xml").toFile());
            featureModel.load();
            IFeature feature = featureModel.getFeature();
            if (!bundle.getName().equals(feature.getPlugin()) || (v = cspec.getVersion()) == null) continue;
            v = VersionHelper.replaceQualifier((Version)v, null);
            ctx.getGlobalContext().addProperty(String.valueOf(bundle.getName()) + ".unqualified.owner.version", (Object)v.toString());
            break;
        }
        return Status.OK_STATUS;
    }
}

