/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.actor;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.actor.MissingPrerequisiteException;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.PDETargetPlatform;
import org.eclipse.buckminster.pde.tasks.BundlesAction;
import org.eclipse.buckminster.pde.tasks.CategoriesAction;
import org.eclipse.buckminster.pde.tasks.FeaturesAction;
import org.eclipse.buckminster.pde.tasks.MirrorsSiteAction;
import org.eclipse.buckminster.pde.tasks.ProductAction;
import org.eclipse.buckminster.pde.tasks.RemoveUnpackedSiblingsAction;
import org.eclipse.buckminster.pde.tasks.SiteReferencesAction;
import org.eclipse.buckminster.pde.tasks.VersionConsolidator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureManifestParser;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundleShapeAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2SiteGenerator
extends AbstractActor {
    public static final String ID = "p2SiteGenerator";
    public static final String ALIAS_SITE = "site";
    public static final String ALIAS_SITE_DEFINER = "site.definer";
    public static final String ALIAS_PRODUCT_CONFIGS = "product.configs";
    private static final String MATCH_ALL = "*";
    private static final String WS_CARBON = "carbon";
    private static final String WS_COCOA = "cocoa";
    private static final String WS_GTK = "gtk";
    private static final String WS_MOTIF = "motif";
    private static final String WS_WIN32 = "win32";
    private static final String OS_AIX = "aix";
    private static final String OS_HPUX = "hpux";
    private static final String OS_LINUX = "linux";
    private static final String OS_MACOSX = "macosx";
    private static final String OS_SOLARIS = "solaris";
    private static final String OS_WIN32 = "win32";
    private static final String ARCH_IA64_32 = "ia64_32";
    private static final String ARCH_PPC = "ppc";
    private static final String ARCH_PPC64 = "ppc64";
    private static final String ARCH_SPARC = "sparc";
    private static final String ARCH_X86 = "x86";
    private static final String ARCH_X86_64 = "x86_64";
    private static final String[][] defaultKnownConfigs = new String[][]{{"carbon", "macosx", "ppc"}, {"carbon", "macosx", "x86"}, {"cocoa", "macosx", "x86"}, {"cocoa", "macosx", "x86_64"}, {"gtk", "linux", "ppc"}, {"gtk", "linux", "ppc64"}, {"gtk", "linux", "x86"}, {"gtk", "linux", "x86_64"}, {"gtk", "solaris", "sparc"}, {"gtk", "solaris", "x86"}, {"motif", "aix", "ppc"}, {"motif", "hpux", "ia64_32"}, {"motif", "linux", "x86"}, {"motif", "solaris", "sparc"}, {"win32", "win32", "x86"}, {"win32", "win32", "x86_64"}};

    public static String[] getConfigurations(Map<String, ? extends Object> props) {
        String targetArch;
        String targetOS;
        String targetWS = props.get("target.ws").toString();
        if (targetWS == null) {
            targetWS = TargetPlatform.getWS();
        }
        if ((targetOS = props.get("target.os").toString()) == null) {
            targetOS = TargetPlatform.getOS();
        }
        if ((targetArch = props.get("target.arch").toString()) == null) {
            targetArch = TargetPlatform.getOSArch();
        }
        if (!(MATCH_ALL.equals(targetOS) || MATCH_ALL.equals(targetWS) || MATCH_ALL.equals(targetArch))) {
            return new String[]{String.valueOf(targetWS) + '.' + targetOS + '.' + targetArch};
        }
        ArrayList<String> possibleMatches = new ArrayList<String>();
        String[][] stringArray = defaultKnownConfigs;
        int n = defaultKnownConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] config = stringArray[n2];
            if (P2SiteGenerator.isMatch(config, targetWS, targetOS, targetArch)) {
                possibleMatches.add(String.valueOf(config[0]) + '.' + config[1] + '.' + config[2]);
            }
            ++n2;
        }
        return possibleMatches.toArray(new String[possibleMatches.size()]);
    }

    private static void addProductAction(IActionContext ctx, File sourceFolder, List<IPublisherAction> actions, IProductDescriptor product, Map<String, String> buildProperties, boolean asSiteDefiner) throws CoreException {
        String flavor = buildProperties.get("org.eclipse.p2.flavor");
        if (flavor == null) {
            flavor = "tooling";
        }
        File exeFeature = null;
        IFeatureModel launcherFeature = PDETargetPlatform.getBestFeature("org.eclipse.equinox.executable", null, null);
        if (launcherFeature == null) {
            launcherFeature = PDETargetPlatform.getBestFeature("org.eclipse.rcp", null, null);
        }
        if (launcherFeature == null) {
            launcherFeature = PDETargetPlatform.getBestFeature("org.eclipse.platform.launchers", null, null);
        }
        if (launcherFeature != null) {
            exeFeature = new File(launcherFeature.getInstallLocation());
        }
        if (asSiteDefiner && product.useFeatures()) {
            List features = product.getFeatures();
            actions.add((IPublisherAction)new CategoriesAction(sourceFolder, buildProperties, features));
        }
        actions.add((IPublisherAction)new ProductAction(ctx, null, product, flavor, exeFeature));
    }

    private static IProductDescriptor getProductDescriptor(File productFile) throws CoreException {
        try {
            return new ProductFile(productFile.getAbsolutePath());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private static boolean isMatch(String[] config, String targetWS, String targetOS, String targetArch) {
        return !(!MATCH_ALL.equals(targetWS) && !config[0].equals(targetWS) || !MATCH_ALL.equals(targetOS) && !config[1].equals(targetOS) || !MATCH_ALL.equals(targetArch) && !config[2].equals(targetArch));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Feature parse(File sourceFolder, File featureFile) throws CoreException {
        Feature feature;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(featureFile));
            FeatureManifestParser parser = new FeatureManifestParser();
            Feature feature2 = parser.parse((InputStream)input, featureFile.toURI().toURL());
            if (feature2 == null) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_parse_feature_manifest_file_0, (Object)featureFile), (Object[])new Object[0]);
            }
            List messageKeys = parser.getMessageKeys();
            String[] keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
            feature2.setLocalizations(LocalizationHelper.getDirPropertyLocalizations((File)sourceFolder, (String)"feature", null, (String[])keyStrings));
            feature2.setLocation(sourceFolder.toString());
            feature = feature2;
        }
        catch (IOException e) {
            try {
                throw BuckminsterException.fromMessage((Throwable)e, (String)NLS.bind((String)Messages.unable_to_parse_feature_manifest_file_0, (Object)featureFile), (Object[])new Object[0]);
                catch (SAXException e2) {
                    throw BuckminsterException.fromMessage((Throwable)e2, (String)NLS.bind((String)Messages.unable_to_parse_feature_manifest_file_0, (Object)featureFile), (Object[])new Object[0]);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        return feature;
    }

    /*
     * Loose catch block
     */
    private static Map<String, String> readBuildProperties(File sourceFolder) throws CoreException {
        BufferedInputStream input = null;
        try {
            File buildProps = new File(sourceFolder, "build.properties");
            input = new BufferedInputStream(new FileInputStream(buildProps));
            BMProperties bMProperties = new BMProperties((InputStream)input);
            IOUtils.close((Closeable)input);
            return bMProperties;
        }
        catch (FileNotFoundException e) {
            Map<String, String> map = Collections.emptyMap();
            return map;
        }
        catch (IOException e2) {
            throw BuckminsterException.wrap((Throwable)e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.close(input);
        }
    }

    public boolean isUpToDate(Action action, IModelCache ctx, long prerequisiteAge, long oldestTarget) throws CoreException {
        if (!super.isUpToDate(action, ctx, prerequisiteAge, oldestTarget)) {
            return false;
        }
        IPath outputDir = action.getProductBase();
        if (outputDir == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.missing_product_base_in_0_actor, (Object)ID), (Object[])new Object[0]);
        }
        Map properties = ctx.getProperties();
        outputDir = new Path((String)ExpandingProperties.expand((Map)properties, (Object)outputDir.toPortableString(), (int)0));
        return outputDir.append("content.jar").toFile().exists() && outputDir.append("artifacts.jar").toFile().exists();
    }

    public void run(IActionContext ctx, File siteDefiner, File sourceFolder, List<File> productConfigs, File siteFolder, Map<String, ? extends Object> properties) throws CoreException {
        String siteDescriptorName;
        Feature siteDescriptor;
        if (siteDefiner == null || siteFolder == null) {
            return;
        }
        String fileName = siteDefiner.getName();
        PublisherInfo info = new PublisherInfo();
        info.setConfigurations(P2SiteGenerator.getConfigurations(properties));
        if (fileName.equals("feature.xml")) {
            Feature feature = P2SiteGenerator.parse(sourceFolder, siteDefiner);
            if (feature == null) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_parse_feature_from_0, (Object)siteDefiner), (Object[])new Object[0]);
            }
            siteDescriptor = feature;
            siteDescriptorName = feature.getLabel();
            if (siteDescriptorName == null) {
                siteDescriptorName = feature.getId();
            }
        } else {
            IProductDescriptor productDesc = P2SiteGenerator.getProductDescriptor(siteDefiner);
            siteDescriptorName = productDesc.getProductName();
            if (siteDescriptorName == null) {
                siteDescriptorName = productDesc.getId();
            }
            siteDescriptor = productDesc;
        }
        IProvisioningAgent agent = CorePlugin.getDefault().getResolverAgent();
        URI siteURI = siteFolder.toURI();
        SimpleArtifactRepositoryFactory arFactory = new SimpleArtifactRepositoryFactory();
        arFactory.setAgent(agent);
        IArtifactRepository ar = arFactory.create(siteURI, String.valueOf(siteDescriptorName) + " - Artifact Repository", null, null);
        String trueStr = Boolean.toString(true);
        ar.setProperty("p2.compressed", trueStr);
        ar.setProperty("publishPackFilesAsSiblings", trueStr);
        info.setArtifactRepository(ar);
        info.setArtifactOptions(3);
        SimpleMetadataRepositoryFactory mdrFactory = new SimpleMetadataRepositoryFactory();
        mdrFactory.setAgent(agent);
        IMetadataRepository mdr = mdrFactory.create(siteURI, siteDescriptorName, null, null);
        mdr.setProperty("p2.compressed", trueStr);
        info.setMetadataRepository(mdr);
        this.addAdvice(siteDescriptor, info);
        IPublisherAction[] actions = this.createActions(ctx, sourceFolder, siteDescriptor, siteFolder, productConfigs);
        Publisher publisher = new Publisher((IPublisherInfo)info);
        IStatus result = publisher.publish(actions, (IProgressMonitor)new NullProgressMonitor());
        if (result.getSeverity() == 4) {
            throw new CoreException(result);
        }
    }

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        List<File> productConfigFiles;
        Action action = ctx.getAction();
        IPath outputPath = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)action, (boolean)false);
        IPath site = null;
        IPath siteDefiner = null;
        CSpec cspec = action.getCSpec();
        List productConfigs = null;
        Logger logger = PDEPlugin.getLogger();
        for (Prerequisite preq : action.getPrerequisites()) {
            Attribute rt;
            if (ALIAS_SITE.equals(preq.getAlias())) {
                rt = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
                if (rt == null) continue;
                site = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)rt, (boolean)true);
                continue;
            }
            if (ALIAS_SITE_DEFINER.equals(preq.getAlias())) {
                rt = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
                if (rt == null) continue;
                siteDefiner = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)rt, (boolean)false);
                continue;
            }
            if (ALIAS_PRODUCT_CONFIGS.equals(preq.getAlias())) {
                rt = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
                productConfigs = AbstractActor.getPathList((IActionContext)ctx, (Attribute)rt, (boolean)false);
                continue;
            }
            if (!preq.isContributor()) continue;
            logger.warning("prerequisite with name %s is ignored by action %s (set contributor=\"false\" on the prerequisite to get rid of this warning)", new Object[]{preq.getName(), action.getQualifiedName()});
        }
        if (site == null) {
            throw new MissingPrerequisiteException(action, (Object)ALIAS_SITE);
        }
        if (siteDefiner == null) {
            throw new MissingPrerequisiteException(action, (Object)ALIAS_SITE_DEFINER);
        }
        if (!outputPath.hasTrailingSeparator()) {
            throw new IllegalArgumentException(NLS.bind((String)org.eclipse.buckminster.core.Messages.output_of_action_0_must_be_folder, (Object)action.getQualifiedName()));
        }
        File outputDir = outputPath.toFile().getAbsoluteFile();
        outputDir.mkdirs();
        Map props = ctx.getProperties();
        File siteDir = null;
        File siteFile = site.toFile().getAbsoluteFile();
        if (siteFile.isDirectory()) {
            FileUtils.deepCopy((File)siteFile, (File)outputDir, (ConflictResolution)ConflictResolution.REPLACE, (IProgressMonitor)monitor);
            siteDir = outputDir;
        } else if (siteFile.getName().endsWith(".zip")) {
            siteDir = new File(props.get("buckminster.temp").toString());
            try {
                org.eclipse.equinox.internal.p2.core.helpers.FileUtils.unzipFile((File)siteFile, (File)siteDir);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        File siteDefinerFile = siteDefiner.toFile().getAbsoluteFile();
        if (productConfigs == null) {
            productConfigFiles = Collections.emptyList();
        } else {
            productConfigFiles = new ArrayList(productConfigs.size());
            for (IPath path : productConfigs) {
                File productConfigFile = path.toFile().getAbsoluteFile();
                if (productConfigFile.equals(siteDefinerFile)) continue;
                productConfigFiles.add(productConfigFile);
            }
        }
        this.run(ctx, siteDefinerFile, ctx.getComponentLocation().toFile(), productConfigFiles, siteDir, ctx.getProperties());
        if (siteDir != null && siteDir != outputDir) {
            File outputZip = new File(outputDir, siteFile.getName());
            try {
                org.eclipse.equinox.internal.p2.core.helpers.FileUtils.zip((File[])siteDir.listFiles(), null, (File)outputZip, (FileUtils.IPathComputer)org.eclipse.equinox.internal.p2.core.helpers.FileUtils.createRootPathComputer((File)siteDir));
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private void addAdvice(Object siteDescriptor, PublisherInfo info) {
        if (siteDescriptor instanceof Feature) {
            Feature feature = (Feature)siteDescriptor;
            FeatureEntry[] entries = feature.getEntries();
            int i = 0;
            while (i < entries.length) {
                FeatureEntry entry = entries[i];
                if (entry.isUnpack() && entry.isPlugin() && !entry.isRequires()) {
                    info.addAdvice((IPublisherAdvice)new BundleShapeAdvice(entry.getId(), Version.parseVersion((String)entry.getVersion()), "dir"));
                }
                ++i;
            }
        }
    }

    private void collectBundles(CSpec cspec, Map<IVersionedId, CSpec> cspecs, Set<ComponentIdentifier> cis, IActionContext ctx) throws CoreException {
        ComponentIdentifier ci = cspec.getComponentIdentifier();
        if (!cis.add(ci)) {
            return;
        }
        if ("osgi.bundle".equals(ci.getComponentTypeID()) && cspecs.put((IVersionedId)new VersionedId(ci.getName(), ci.getVersion()), cspec) != null) {
            return;
        }
        Attribute refs = cspec.getAttribute("bundle.jars");
        if (refs == null) {
            return;
        }
        for (Prerequisite preq : refs.getPrerequisites()) {
            Attribute ref = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
            if (ref == null) continue;
            this.collectBundles(ref.getCSpec(), cspecs, cis, ctx);
        }
    }

    private Map<IVersionedId, CSpec> collectBundles(IActionContext ctx) throws CoreException {
        CSpec cspec = ctx.getAction().getCSpec();
        HashMap<IVersionedId, CSpec> cspecs = new HashMap<IVersionedId, CSpec>();
        HashSet<ComponentIdentifier> cis = new HashSet<ComponentIdentifier>();
        this.collectBundles(cspec, cspecs, cis, ctx);
        return cspecs;
    }

    private void collectFeatures(CSpec cspec, Map<IVersionedId, CSpec> cspecs, IActionContext ctx) throws CoreException {
        ComponentIdentifier ci = cspec.getComponentIdentifier();
        if (cspecs.put((IVersionedId)new VersionedId(ci.getName(), ci.getVersion()), cspec) != null) {
            return;
        }
        Attribute refs = cspec.getAttribute("feature.references");
        if (refs == null) {
            return;
        }
        for (Prerequisite preq : refs.getPrerequisites()) {
            Attribute ref = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
            if (ref == null) continue;
            this.collectFeatures(ref.getCSpec(), cspecs, ctx);
        }
    }

    private Map<IVersionedId, CSpec> collectFeatures(IActionContext ctx) throws CoreException {
        CSpec cspec = ctx.getAction().getCSpec();
        HashMap<IVersionedId, CSpec> cspecs = new HashMap<IVersionedId, CSpec>();
        this.collectFeatures(cspec, cspecs, ctx);
        return cspecs;
    }

    private IPublisherAction[] createActions(IActionContext ctx, File sourceFolder, Object siteDescriptor, File siteFolder, List<File> productConfigs) throws CoreException {
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        actions.add((IPublisherAction)new FeaturesAction(new File[]{new File(siteFolder, "features")}, this.collectFeatures(ctx)));
        actions.add((IPublisherAction)new BundlesAction(new File[]{new File(siteFolder, "plugins")}, this.collectBundles(ctx)));
        Map<String, String> buildProperties = P2SiteGenerator.readBuildProperties(sourceFolder);
        if (siteDescriptor instanceof Feature) {
            URLEntry mirrorsSite;
            Feature topFeature = (Feature)siteDescriptor;
            URLEntry[] siteRefs = topFeature.getDiscoverySites();
            if (siteRefs.length > 0) {
                actions.add((IPublisherAction)new SiteReferencesAction(siteRefs));
            }
            if ((mirrorsSite = topFeature.getUpdateSite()) != null && mirrorsSite.getURL() != null) {
                actions.add((IPublisherAction)new MirrorsSiteAction(mirrorsSite.getURL()));
            }
            ArrayList<IVersionedId> featureList = new ArrayList<IVersionedId>();
            FeatureEntry[] featureEntryArray = topFeature.getEntries();
            int n = featureEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureEntry fe = featureEntryArray[n2];
                if (!(fe.isPatch() || fe.isPlugin() || fe.isRequires())) {
                    featureList.add((IVersionedId)new VersionedId(fe.getId(), fe.getVersion()));
                }
                ++n2;
            }
            actions.add((IPublisherAction)new CategoriesAction(sourceFolder, buildProperties, featureList));
        } else {
            IProductDescriptor product = (IProductDescriptor)siteDescriptor;
            P2SiteGenerator.addProductAction(ctx, sourceFolder, actions, product, buildProperties, true);
        }
        for (File productConfigFile : productConfigs) {
            File productSourceFolder = productConfigFile.getParentFile();
            P2SiteGenerator.addProductAction(ctx, productSourceFolder, actions, P2SiteGenerator.getProductDescriptor(productConfigFile), P2SiteGenerator.readBuildProperties(productSourceFolder), false);
        }
        if (!VersionConsolidator.getBooleanProperty(ctx.getProperties(), "site.retain.unpacked", false)) {
            actions.add(new RemoveUnpackedSiblingsAction());
        }
        return actions.toArray(new IPublisherAction[actions.size()]);
    }
}

