/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.datatransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.pde.internal.datatransfer.IImportStructureProvider;

public class FileSystemStructureProvider
implements IImportStructureProvider {
    public static final FileSystemStructureProvider INSTANCE = new FileSystemStructureProvider();

    private FileSystemStructureProvider() {
    }

    public List getChildren(Object element) {
        File folder = (File)element;
        String[] children = folder.list();
        int childrenLength = children == null ? 0 : children.length;
        ArrayList<File> result = new ArrayList<File>(childrenLength);
        int i = 0;
        while (i < childrenLength) {
            result.add(new File(folder, children[i]));
            ++i;
        }
        return result;
    }

    public InputStream getContents(Object element) {
        try {
            return new FileInputStream((File)element);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String getFullPath(Object element) {
        return ((File)element).getPath();
    }

    public String getLabel(Object element) {
        File file = (File)element;
        String name = file.getName();
        if (name.length() == 0) {
            return file.getPath();
        }
        return name;
    }

    public boolean isFolder(Object element) {
        return ((File)element).isDirectory();
    }
}

