/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.dialogs;

import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ContainerGenerator {
    private IPath containerFullPath;
    private IContainer container;

    public ContainerGenerator(IPath containerPath) {
        this.containerFullPath = containerPath;
    }

    public IContainer generateContainer(IProgressMonitor topMonitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("IDEWorkbenchMessages.ContainerGenerator_progressMessage", 1000 * ContainerGenerator.this.containerFullPath.segmentCount());
                if (ContainerGenerator.this.container != null) {
                    return;
                }
                IWorkspaceRoot root = ContainerGenerator.this.getWorkspaceRoot();
                ContainerGenerator.this.container = (IContainer)root.findMember(ContainerGenerator.this.containerFullPath);
                if (ContainerGenerator.this.container != null) {
                    return;
                }
                ContainerGenerator.this.container = (IContainer)root;
                int i = 0;
                while (i < ContainerGenerator.this.containerFullPath.segmentCount()) {
                    String currentSegment = ContainerGenerator.this.containerFullPath.segment(i);
                    IResource resource = ContainerGenerator.this.container.findMember(currentSegment);
                    if (resource != null) {
                        if (resource.getType() == 1) {
                            String msg = NLS.bind((String)"IDEWorkbenchMessages.ContainerGenerator_pathOccupied", (Object)resource.getFullPath().makeRelative());
                            throw new CoreException((IStatus)new Status(4, PDEPlugin.getPluginId(), 1, msg, null));
                        }
                        ContainerGenerator.this.container = (IContainer)resource;
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)1000);
                    } else if (i == 0) {
                        IProject projectHandle = ContainerGenerator.this.createProjectHandle(root, currentSegment);
                        ContainerGenerator.this.container = (IContainer)ContainerGenerator.this.createProject(projectHandle, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                    } else {
                        IFolder folderHandle = ContainerGenerator.this.createFolderHandle(ContainerGenerator.this.container, currentSegment);
                        ContainerGenerator.this.container = (IContainer)ContainerGenerator.this.createFolder(folderHandle, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                    }
                    ++i;
                }
            }
        }, null, 0, topMonitor);
        return this.container;
    }

    private IFolder createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        folderHandle.create(false, true, monitor);
        MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
        return folderHandle;
    }

    private IFolder createFolderHandle(IContainer resourceContainer, String folderName) {
        return resourceContainer.getFolder((IPath)new Path(folderName));
    }

    private IProject createProject(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            projectHandle.open(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        }
        finally {
            monitor.done();
        }
        return projectHandle;
    }

    private IProject createProjectHandle(IWorkspaceRoot root, String projectName) {
        return root.getProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

