/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.imports;

import java.io.File;
import java.util.List;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.EclipseImportReaderType;
import org.eclipse.buckminster.pde.internal.datatransfer.FileSystemStructureProvider;
import org.eclipse.buckminster.pde.internal.datatransfer.IImportStructureProvider;
import org.eclipse.buckminster.pde.internal.datatransfer.ImportOperation;
import org.eclipse.buckminster.pde.internal.dialogs.IOverwriteQuery;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureImportOperation
implements IWorkspaceRunnable {
    private final IFeatureModel model;
    private final NodeQuery query;
    private final EclipseImportReaderType classpathCollector;
    private final boolean binary;
    private final IWorkspaceRoot root;
    private final IPath destination;

    public FeatureImportOperation(EclipseImportReaderType classpathCollector, IFeatureModel model, NodeQuery query, IPath destination, boolean binary) {
        this.classpathCollector = classpathCollector;
        this.model = model;
        this.binary = binary;
        this.query = query;
        this.root = ResourcesPlugin.getWorkspace().getRoot();
        this.destination = destination;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.createProject(monitor);
        MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
    }

    private void createBuildProperties(IProject project) {
        IFile file = project.getFile("build.properties");
        if (file.exists()) {
            return;
        }
        WorkspaceBuildModel buildModel = new WorkspaceBuildModel(file);
        IBuildEntry ientry = buildModel.getFactory().createEntry("bin.includes");
        try {
            IResource[] res = project.members();
            int i = 0;
            while (i < res.length) {
                String path = res[i].getProjectRelativePath().toString();
                if (!path.equals(".project")) {
                    ientry.addToken(path);
                }
                ++i;
            }
            buildModel.getBuild().add(ientry);
            buildModel.save();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void createProject(IProgressMonitor monitor) throws CoreException {
        MaterializationContext context = (MaterializationContext)this.query.getContext();
        ComponentRequest request = this.query.getComponentRequest();
        String projectName = request.getProjectName();
        monitor.beginTask(NLS.bind((String)Messages.importing_feature_0, (Object)projectName), 100);
        IProject project = this.root.getProject(projectName);
        try {
            ConflictResolution conflictResolution = context.getMaterializationSpec().getConflictResolution(WorkspaceInfo.getResolution((ComponentRequest)request, (boolean)false));
            if (project.exists()) {
                switch (conflictResolution) {
                    case FAIL: {
                        throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.project_0_already_exists, (Object)projectName), (Object[])new Object[0]);
                    }
                    case KEEP: {
                        return;
                    }
                }
                project.delete(true, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                try {
                    RepositoryProvider.unmap((IProject)project);
                }
                catch (TeamException teamException) {}
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(projectName);
            FileUtils.prepareDestination((File)this.destination.toFile(), (ConflictResolution)conflictResolution, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            description.setLocation(this.destination);
            project.create(description, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
            project.open(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
            File featureDir = new File(this.model.getInstallLocation());
            this.importContent(featureDir, project.getFullPath(), FileSystemStructureProvider.INSTANCE, null, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            IFolder folder = project.getFolder("META-INF");
            if (folder.exists()) {
                folder.delete(true, null);
            }
            if (this.binary) {
                project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
            }
            this.createBuildProperties(project);
            this.setProjectNatures(project, this.model, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                this.classpathCollector.addProjectClasspath(project, this.getClasspath(project, this.model));
            }
            project.delete(false, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
        }
        finally {
            monitor.done();
        }
    }

    private IClasspathEntry[] getClasspath(IProject project, IFeatureModel featureModel) throws JavaModelException {
        IClasspathEntry jreCPEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
        String libName = featureModel.getFeature().getInstallHandler().getLibrary();
        IClasspathEntry handlerCPEntry = JavaCore.newLibraryEntry((IPath)project.getFullPath().append(libName), null, null);
        return new IClasspathEntry[]{jreCPEntry, handlerCPEntry};
    }

    private void importContent(Object source, IPath destPath, IImportStructureProvider provider, List<?> filesToImport, IProgressMonitor monitor) throws CoreException {
        IStatus status;
        IOverwriteQuery overwrite = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        ImportOperation op = new ImportOperation(destPath, source, provider, overwrite);
        op.setCreateContainerStructure(false);
        if (filesToImport != null) {
            op.setFilesToImport(filesToImport);
        }
        if ((status = op.runInWorkspace(monitor)) == Status.CANCEL_STATUS || monitor.isCanceled()) {
            throw new OperationCanceledException(status.getMessage());
        }
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    private boolean needsJavaNature(IFeatureModel featureModel) {
        IFeatureInstallHandler handler = featureModel.getFeature().getInstallHandler();
        if (handler == null) {
            return false;
        }
        String libName = handler.getLibrary();
        if (libName == null || libName.length() == 0) {
            return false;
        }
        File lib = new File(featureModel.getInstallLocation(), libName);
        return lib.exists();
    }

    private void setProjectNatures(IProject project, IFeatureModel model, IProgressMonitor monitor) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (this.needsJavaNature(model)) {
            desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.FeatureNature"});
        } else {
            desc.setNatureIds(new String[]{"org.eclipse.pde.FeatureNature"});
        }
        project.setDescription(desc, monitor);
    }
}

