/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.mapfile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.Replace;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.mapfile.MapFileEntry;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.FetchTaskFactoriesRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFile {
    private static final Pattern pattern = Pattern.compile("^\\s*([^@=,\\s]+)\\s*@\\s*([^@,=\\s]+)\\s*(?:,\\s*([^@,=\\s]+)\\s*)?=(?:\\s*([A-Za-z_][A-Za-z0-9_-]*)\\s*,)?\\s*\\s*([^\\s]+)\\s*$");
    private static FetchTaskFactoriesRegistry fetchTaskFactories;

    public static void parse(InputStream inputStream, String streamName, Replace replace, Map<String, ? extends Object> queryProps, List<MapFileEntry> receivingList) throws IOException {
        String line;
        CorePlugin core = CorePlugin.getDefault();
        Logger logger = CorePlugin.getLogger();
        if (fetchTaskFactories == null) {
            fetchTaskFactories = new FetchTaskFactoriesRegistry();
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
        block8: while ((line = input.readLine()) != null) {
            IReaderType readerType;
            Version version;
            String ctypeId;
            String type;
            Matcher m;
            int len = line.length();
            int idx = 0;
            while (idx < len) {
                char c = line.charAt(idx);
                if (!Character.isWhitespace(c)) {
                    if (c != '!' && c != '#') break;
                    continue block8;
                }
                ++idx;
            }
            if (idx == len) continue;
            if (replace != null) {
                line = replace.replace(line);
                line = (String)ExpandingProperties.expand(queryProps, (Object)line, (int)0);
            }
            if (!(m = pattern.matcher(line)).matches()) continue;
            String fetchType = m.group(4);
            String fetchTypeSpecific = m.group(5);
            if (fetchType == null) {
                fetchType = "CVS";
            } else if (fetchType.equals("COPY")) {
                logger.warning(NLS.bind((String)Messages.fetch_type_COPY_not_supported_map_0, (Object)streamName), new Object[0]);
                continue;
            }
            IFetchFactory ff = fetchTaskFactories.getFactory(fetchType);
            if (ff == null) {
                fetchTypeSpecific = String.valueOf(fetchType) + ',' + fetchTypeSpecific;
                fetchType = "CVS";
                ff = fetchTaskFactories.getFactory(fetchType);
                if (ff == null) {
                    logger.warning(NLS.bind((String)Messages.no_factory_found_for_0_in_PDEmap_1, (Object)fetchType, (Object)streamName), new Object[0]);
                    continue;
                }
            }
            if ("plugin".equals(type = m.group(1)) || "bundle".equals(type) || "fragment".equals(type)) {
                ctypeId = "osgi.bundle";
            } else if ("feature".equals(type)) {
                ctypeId = "eclipse.feature";
            } else {
                logger.warning(NLS.bind((String)Messages.unrecognized_component_type_0_in_PDEmap_1, (Object)type, (Object)streamName), new Object[0]);
                continue;
            }
            String vstr = m.group(3);
            try {
                version = vstr == null ? null : Version.parseVersion((String)vstr);
            }
            catch (IllegalArgumentException e) {
                logger.warning(NLS.bind((String)Messages.badly_formatted_version_0_in_PDEmap_1, (Object)vstr, (Object)streamName), new Object[0]);
                continue;
            }
            String identifier = m.group(2);
            HashMap<String, String> props = new HashMap<String, String>();
            try {
                ff.parseMapFileEntry(fetchTypeSpecific, null, props);
            }
            catch (Exception e) {
                logger.warning(NLS.bind((String)Messages.fetch_factory_0_unable_to_parse_1_in_PDEmap_2, (Object[])new Object[]{fetchType, fetchTypeSpecific, streamName}), new Object[0]);
                continue;
            }
            String readerTypeID = fetchType.toLowerCase(Locale.ENGLISH);
            if ("get".equals(readerTypeID)) {
                readerTypeID = "url";
                String src = (String)props.get("src");
                if (src.endsWith(".jar") || src.endsWith(".zip")) {
                    String vcName;
                    int lastSlash = src.lastIndexOf(47);
                    if (lastSlash < 0) {
                        lastSlash = 0;
                    }
                    if ((vcName = src.substring(lastSlash + 1, src.length() - 4)).startsWith(String.valueOf(identifier) + '_')) {
                        try {
                            version = Version.parseVersion((String)vcName.substring(identifier.length() + 1));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
            } else if (readerTypeID.equals("p2iu")) {
                readerTypeID = "p2";
            }
            ComponentIdentifier cid = new ComponentIdentifier(identifier, ctypeId, version);
            try {
                readerType = core.getReaderType(readerTypeID);
            }
            catch (CoreException e) {
                logger.warning(NLS.bind((String)Messages.Unable_to_obtain_readertype_for_fetchtype_0_in_PDEmap_1, (Object)fetchType, (Object)streamName), new Object[0]);
                continue;
            }
            receivingList.add(new MapFileEntry(cid, readerType, props));
        }
    }
}

