/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.mapprovider;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.common.model.Replace;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.mapfile.MapFile;
import org.eclipse.buckminster.pde.mapfile.MapFileEntry;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDEMapProvider
extends Provider {
    public static final String BM_PDEMAP_PROVIDER_NS = "http://www.eclipse.org/buckminster/PDEMapProvider-1.0";
    public static final String BM_PDEMAP_PROVIDER_PREFIX = "pmp";
    private final Replace replace;

    public PDEMapProvider(SearchPath searchPath, String remoteReaderType, String[] componentTypes, VersionConverterDesc vcDesc, Format uri, Filter resolutionFilter, Map<String, String> properties, Replace replace, Documentation documentation) {
        super(searchPath, remoteReaderType, componentTypes, vcDesc, uri, null, null, resolutionFilter, properties, null, documentation);
        this.replace = replace;
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        super.addPrefixMappings(prefixMappings);
        prefixMappings.put(BM_PDEMAP_PROVIDER_PREFIX, BM_PDEMAP_PROVIDER_NS);
    }

    public ProviderMatch findMatch(NodeQuery query, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 100);
        try {
            VersionRange vd;
            String providerURI = this.getURI(query.getProperties());
            String readerType = this.getReaderTypeId();
            ProviderScore score = query.getProviderScore(this.isMutable(), this.hasSource());
            if (score == ProviderScore.REJECTED) {
                ResolverDecision decision = query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, new Object[]{readerType, providerURI, org.eclipse.buckminster.core.Messages.Score_is_below_threshold});
                problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
                return null;
            }
            MapFileEntry tv = this.getMapFileEntry(query, problemCollector, this.getMap(query, problemCollector, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50)));
            if (tv == null) {
                String msg = NLS.bind((String)Messages.PDEMapProvider_0_for_1_did_not_find_any_maps, (Object)readerType, (Object)providerURI);
                problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, msg, null));
                return null;
            }
            Map<String, String> properties = tv.getProperties();
            Version v = null;
            VersionSelector vs = null;
            IReaderType rt = tv.getReaderType();
            String id = null;
            if ("p2".equals(rt.getId())) {
                String vstr = properties.get("version");
                if (vstr != null) {
                    v = Version.create((String)vstr);
                }
                id = properties.get("id");
            } else {
                IVersionConverter vc;
                String tag = properties.get("tag");
                if (tag != null) {
                    vs = VersionSelector.tag((String)tag);
                }
                if ((vc = this.getVersionConverter()) != null) {
                    v = vc.createVersion(vs);
                }
            }
            if (v != null && (vd = query.getVersionRange()) != null && !vd.isIncluded(v)) {
                ResolverDecision decision = query.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{v, NLS.bind((String)org.eclipse.buckminster.core.Messages.Not_designated_by_0, (Object)vd)});
                problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
                return null;
            }
            VersionMatch vm = new VersionMatch(v, vs, -1L, null, id);
            ComponentRequest rq = query.getComponentRequest();
            String repoLocator = rt.convertFetchFactoryLocator(properties, rq.getName());
            Format uri = new Format(repoLocator);
            Map props = rt.getFetchFactoryProviderProps(properties, (Provider)this);
            Provider delegated = new Provider(this.getSearchPath(), rt.getId(), this.getComponentTypeIDs(), this.getVersionConverterDesc(), uri, null, null, this.getResolutionFilter(), props, null, null);
            String ctypeID = rq.getComponentTypeID();
            if (ctypeID == null) {
                ProviderMatch providerMatch = delegated.findMatch(query, problemCollector, monitor);
                return providerMatch;
            }
            IComponentType ctype = tv.getComponentIdentifier().getComponentType();
            ProviderMatch pm = new ProviderMatch((Provider)this, ctype, vm, score, query);
            pm.setProvider(delegated);
            pm.setComponentType(ctype);
            ProviderMatch providerMatch = pm;
            return providerMatch;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<ComponentIdentifier, MapFileEntry> getMap(NodeQuery query, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        Map userCache;
        monitor.beginTask(null, 700);
        Map map = userCache = query.getContext().getUserCache();
        synchronized (map) {
            Map<ComponentIdentifier, MapFileEntry> map2 = this.getCachedMap(userCache);
            if (map2 != null) {
                return map2;
            }
            FileHandle folderHandle = null;
            try {
                VersionSelector[] btPath = query.getBranchTagPath();
                if (btPath.length == 0) {
                    folderHandle = this.materializeMaps(null, query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
                } else {
                    CoreException lastException = null;
                    VersionSelector[] versionSelectorArray = btPath;
                    int n = btPath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VersionSelector bt = versionSelectorArray[n2];
                        try {
                            folderHandle = this.materializeMaps(bt, query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
                            lastException = null;
                            break;
                        }
                        catch (CoreException e) {
                            lastException = e;
                            ++n2;
                        }
                    }
                    if (lastException != null) {
                        throw lastException;
                    }
                }
                map2 = new HashMap<ComponentIdentifier, MapFileEntry>();
                File folder = folderHandle.getFile();
                String[] mapFiles = folder.list();
                if (mapFiles == null || mapFiles.length == 0) {
                    return null;
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                int amountPerFile = 100 / mapFiles.length;
                Map queryProps = this.getProperties(query.getProperties());
                String[] stringArray = mapFiles;
                int n = mapFiles.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n) {
                        map2 = Collections.unmodifiableMap(map2);
                        this.cacheMap(userCache, map2);
                        Map<ComponentIdentifier, MapFileEntry> map3 = map2;
                        return map3;
                    }
                    String file = stringArray[n3];
                    if (file.endsWith(".map")) {
                        this.collectEntries(queryProps, new File(folder, file), map2);
                    }
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)amountPerFile);
                    ++n3;
                }
            }
            catch (CoreException e) {
                problemCollector.add(e.getStatus());
                PDEPlugin.getLogger().debug(e.getMessage(), new Object[0]);
                return null;
            }
            finally {
                if (folderHandle != null && folderHandle.isTemporary()) {
                    FileUtils.deleteRecursive((File)folderHandle.getFile(), (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                monitor.done();
            }
        }
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi:type", "CDATA", "pmp:PDEMapProvider");
    }

    private void cacheMap(Map<UUID, Object> userCache, Map<ComponentIdentifier, MapFileEntry> map) {
        userCache.put(this.getId(), map);
    }

    private void collectEntries(Map<String, ? extends Object> queryProps, File mapFile, Map<ComponentIdentifier, MapFileEntry> map) throws CoreException {
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(mapFile);
                ArrayList<MapFileEntry> list = new ArrayList<MapFileEntry>();
                MapFile.parse(input, mapFile.getCanonicalPath(), this.replace, queryProps, list);
                for (MapFileEntry entry : list) {
                    map.put(entry.getComponentIdentifier(), entry);
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
    }

    private Map<ComponentIdentifier, MapFileEntry> getCachedMap(Map<UUID, Object> userCache) {
        return (Map)userCache.get(this.getId());
    }

    private MapFileEntry getMapFileEntry(NodeQuery query, MultiStatus problemCollector, Map<ComponentIdentifier, MapFileEntry> map) {
        if (map == null) {
            return null;
        }
        ComponentRequest wanted = query.getComponentRequest();
        String name = wanted.getName();
        String ctype = wanted.getComponentTypeID();
        VersionRange vd = wanted.getVersionRange();
        ComponentIdentifier candidate = null;
        MapFileEntry candidateEntry = null;
        for (Map.Entry<ComponentIdentifier, MapFileEntry> entry : map.entrySet()) {
            ComponentIdentifier cn = entry.getKey();
            if (!cn.getName().equals(name) || !Trivial.equalsAllowNull((Object)ctype, (Object)cn.getComponentTypeID())) continue;
            Version v = cn.getVersion();
            if (vd != null && v != null && !vd.isIncluded(v) || candidate != null && (v == null || candidate.getVersion() != null && candidate.getVersion().compareTo((Object)v) > 0)) continue;
            candidate = cn;
            candidateEntry = entry.getValue();
        }
        if (candidateEntry == null) {
            String msg = NLS.bind((String)Messages.PDEMapProvider_0_for_1_unable_to_find_2_in_map, (Object[])new Object[]{this.getReaderTypeId(), this.getURI(query.getProperties()), wanted});
            problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, msg, null));
            PDEPlugin.getLogger().debug(msg, new Object[0]);
        }
        return candidateEntry;
    }

    private FileHandle materializeMaps(VersionSelector vs, NodeQuery query, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)500);
        ProviderMatch match = new ProviderMatch((Provider)this, CorePlugin.getDefault().getComponentType("unknown"), new VersionMatch(null, vs, -1L, null, null), ProviderScore.GOOD, query);
        IComponentReader reader = match.getReader(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
        try {
            File location = reader.getLocation();
            if (location != null) {
                FileHandle fileHandle = new FileHandle(location.getAbsolutePath(), location, false);
                return fileHandle;
            }
            File tempFolder = FileUtils.createTempFolder((String)"bucky", (String)".tmp");
            try {
                ((ICatalogReader)reader).innerMaterialize(Path.fromOSString((String)tempFolder.getAbsolutePath()), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)350));
            }
            catch (CoreException e) {
                FileUtils.deleteRecursive((File)tempFolder, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                throw e;
            }
            FileHandle fileHandle = new FileHandle(tempFolder.getName(), tempFolder, true);
            return fileHandle;
        }
        finally {
            IOUtils.close((Closeable)reader);
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }
}

