/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.prefs;

import java.util.ArrayList;
import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.service.prefs.BackingStoreException;

public class BaselineHandler
extends BasicPreferenceHandler {
    public static void rebuildApiProjects() throws CoreException {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) {
                projects.add(project);
            }
            ++n2;
        }
        if (projects.size() == 0) {
            return;
        }
        Job buildJob = Util.getBuildJob((IProject[])projects.toArray(new IProject[projects.size()]));
        buildJob.schedule();
        try {
            buildJob.join();
            IStatus status = buildJob.getResult();
            if (status.getSeverity() == 4) {
                throw new CoreException(status);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String get(String defaultValue) throws CoreException {
        IApiBaselineManager baselineManager = ApiPlugin.getDefault().getApiBaselineManager();
        IApiBaseline baseline = baselineManager.getDefaultApiBaseline();
        return baseline == null ? null : baseline.getName();
    }

    public void set(String baselineName) throws BackingStoreException {
        IApiBaselineManager baselineManager = ApiPlugin.getDefault().getApiBaselineManager();
        IApiBaseline active = baselineManager.getDefaultApiBaseline();
        if (active != null && active.getName().equals(baselineName)) {
            return;
        }
        try {
            IApiBaseline[] iApiBaselineArray = baselineManager.getApiBaselines();
            int n = iApiBaselineArray.length;
            int n2 = 0;
            while (n2 < n) {
                IApiBaseline baseline = iApiBaselineArray[n2];
                if (baseline.getName().equals(baselineName)) {
                    baselineManager.setDefaultApiBaseline(baselineName);
                    BaselineHandler.rebuildApiProjects();
                    return;
                }
                ++n2;
            }
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Found_no_baseline_named_0, (Object)baselineName), (Object[])new Object[0]);
        }
        catch (CoreException e) {
            throw new BackingStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void unset() throws BackingStoreException {
        IApiBaselineManager baselineManager = ApiPlugin.getDefault().getApiBaselineManager();
        if (baselineManager.getDefaultApiBaseline() != null) {
            try {
                baselineManager.setDefaultApiBaseline(null);
                BaselineHandler.rebuildApiProjects();
            }
            catch (CoreException e) {
                throw new BackingStoreException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

