/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.prefs;

import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.osgi.service.prefs.BackingStoreException;

abstract class TargetVariableHandler
extends BasicPreferenceHandler
implements ICoreConstants {
    TargetVariableHandler() {
    }

    public String get(String defaultValue) throws CoreException {
        Buckminster bucky = Buckminster.getDefault();
        ITargetPlatformService service = null;
        try {
            service = (ITargetPlatformService)bucky.getService(ITargetPlatformService.class);
            ITargetHandle activeHandle = service.getWorkspaceTargetHandle();
            if (activeHandle == null) {
                String string = defaultValue;
                return string;
            }
            ITargetDefinition definition = activeHandle.getTargetDefinition();
            String value = this.get(definition);
            if (value == null) {
                value = defaultValue;
            }
            String string = value;
            return string;
        }
        finally {
            bucky.ungetService((Object)service);
        }
    }

    public void set(String value) throws BackingStoreException {
        Buckminster bucky = Buckminster.getDefault();
        ITargetPlatformService service = null;
        try {
            try {
                service = (ITargetPlatformService)bucky.getService(ITargetPlatformService.class);
                ITargetHandle activeHandle = service.getWorkspaceTargetHandle();
                if (activeHandle == null) {
                    throw new BackingStoreException(Messages.No_active_target_platform);
                }
                ITargetDefinition definition = activeHandle.getTargetDefinition();
                this.set(definition, value);
                service.saveTargetDefinition(definition);
            }
            catch (CoreException e) {
                throw new BackingStoreException(e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            bucky.ungetService(service);
            throw throwable;
        }
        bucky.ungetService((Object)service);
    }

    protected abstract String get(ITargetDefinition var1) throws CoreException;

    protected abstract void set(ITargetDefinition var1, String var2) throws CoreException;
}

