/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Locale;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.swt.tools.IconExe;

public class BrandingIron
implements IXMLConstants {
    private static final String MARKER_NAME = "%EXECUTABLE_NAME%";
    private static final String BUNDLE_NAME = "%BUNDLE_NAME%";
    private static final String ICON_NAME = "%ICON_NAME%";
    private static final String MARKER_KEY = "<key>CFBundleExecutable</key>";
    private static final String BUNDLE_KEY = "<key>CFBundleName</key>";
    private static final String ICON_KEY = "<key>CFBundleIconFile</key>";
    private static final String STRING_START = "<string>";
    private static final String STRING_END = "</string>";
    private static final String XDOC_ICON = "-Xdock:icon=../Resources/Eclipse.icns";
    private String[] icons = null;
    private String name;
    private String os = "win32";
    private boolean brandIcons = true;

    public void brand(ExecutablesDescriptor descriptor) throws Exception {
        String testName;
        if (this.name.startsWith("${")) {
            return;
        }
        if (this.icons == null || this.icons[0].startsWith("${")) {
            this.brandIcons = false;
        }
        File root = descriptor.getLocation();
        String string = testName = this.os.equals("win32") ? String.valueOf(this.name) + ".exe" : this.name;
        if (!root.exists() || !this.brandIcons && new File(root, testName).exists()) {
            return;
        }
        try {
            root = root.getCanonicalFile();
        }
        catch (IOException e) {
            root = root.getAbsoluteFile();
        }
        descriptor.setLocation(root);
        if ("win32".equals(this.os)) {
            this.brandWindows(descriptor);
        } else if ("linux".equals(this.os)) {
            this.brandLinux(descriptor);
        } else if ("macosx".equals(this.os)) {
            this.brandMac(descriptor);
        } else if ("solaris".equals(this.os)) {
            this.brandSolaris(descriptor);
        } else if ("aix".equals(this.os)) {
            this.brandAIX(descriptor);
        } else if ("hpux".equals(this.os)) {
            this.brandHPUX(descriptor);
        }
    }

    public void setIcons(String value) {
        this.icons = value.split(",\\s*");
        if (this.icons[0].startsWith("${")) {
            if (this.icons.length > 1) {
                String[] temp = new String[this.icons.length - 1];
                System.arraycopy(this.icons, 1, temp, 0, temp.length);
                this.icons = temp;
            } else {
                this.icons = null;
            }
        }
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setOS(String value) {
        this.os = value;
    }

    private void brandAIX(ExecutablesDescriptor descriptor) {
        this.renameLauncher(descriptor);
    }

    private void brandHPUX(ExecutablesDescriptor descriptor) {
        this.renameLauncher(descriptor);
    }

    private void brandLinux(ExecutablesDescriptor descriptor) throws Exception {
        this.renameLauncher(descriptor);
        if (this.brandIcons) {
            File icon = null;
            if (this.icons.length > 0) {
                int i = 0;
                while (i < this.icons.length) {
                    if (this.icons[i].toLowerCase(Locale.ENGLISH).endsWith(".xpm")) {
                        icon = new File(this.icons[i]);
                        break;
                    }
                    ++i;
                }
            } else {
                icon = new File(this.icons[0]);
            }
            File targetIcon = new File(descriptor.getLocation(), "icon.xpm");
            Utils.copy((File)icon, (File)targetIcon);
            descriptor.addFile(targetIcon);
        }
    }

    private void brandMac(ExecutablesDescriptor descriptor) throws Exception {
        File root = descriptor.getLocation();
        File target = new File(root, String.valueOf(this.name) + ".app/Contents");
        target.mkdirs();
        new File(target, "MacOS").mkdirs();
        new File(target, "Resources").mkdirs();
        File initialRoot = new File(root, "Eclipse.app/Contents");
        this.copyMacLauncher(descriptor, initialRoot, target);
        String iconName = "";
        if (this.brandIcons) {
            File icon = null;
            if (this.icons.length > 1) {
                int i = 0;
                while (i < this.icons.length) {
                    if (this.icons[i].toLowerCase(Locale.ENGLISH).endsWith(".icns")) {
                        icon = new File(this.icons[i]);
                        break;
                    }
                    ++i;
                }
            } else {
                icon = new File(this.icons[0]);
            }
            if (icon.exists()) {
                iconName = String.valueOf(this.name) + ".icns";
                File initialIcon = new File(initialRoot, "Resources/Eclipse.icns");
                File targetIcon = new File(target, "Resources/" + iconName);
                initialIcon.delete();
                descriptor.removeFile(initialIcon);
                Utils.copy((File)icon, (File)targetIcon);
                descriptor.addFile(targetIcon);
            }
        }
        this.copyMacIni(descriptor, initialRoot, target, iconName);
        this.modifyInfoPListFile(descriptor, initialRoot, target, iconName);
        File splashApp = new File(initialRoot, "Resources/Splash.app");
        if (splashApp.exists()) {
            this.brandMacSplash(descriptor, initialRoot, target, iconName);
        }
        this.moveContents(descriptor, initialRoot, target);
        new File(root, "Eclipse.app").delete();
    }

    private void brandMacSplash(ExecutablesDescriptor descriptor, File initialRoot, File target, String iconName) {
        File targetLauncher;
        String splashMacOS;
        block11: {
            File macOSDir;
            Logger logger;
            block10: {
                logger = PDEPlugin.getLogger();
                String splashContents = "Resources/Splash.app/Contents";
                this.modifyInfoPListFile(descriptor, new File(initialRoot, splashContents), new File(target, splashContents), iconName);
                splashMacOS = String.valueOf(splashContents) + "/MacOS";
                macOSDir = new File(target, "MacOS");
                File splashMacOSDir = new File(target, splashMacOS);
                splashMacOSDir.mkdirs();
                targetLauncher = new File(splashMacOSDir, this.name);
                String osName = System.getProperty("os.name");
                if (osName != null && !osName.startsWith("Windows")) {
                    try {
                        String[] command = new String[]{"ln", "-sf", "../../../MacOS/" + this.name, this.name};
                        Process proc = Runtime.getRuntime().exec(command, null, splashMacOSDir);
                        if (proc.waitFor() != 0) break block10;
                        break block11;
                    }
                    catch (IOException command) {
                    }
                    catch (InterruptedException command) {
                        // empty catch block
                    }
                }
            }
            try {
                Utils.copy((File)new File(macOSDir, this.name), (File)targetLauncher);
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Could not copy macosx splash launcher", new Object[0]);
            }
        }
        File initialLauncher = this.findLauncher(new File(initialRoot, splashMacOS));
        if (initialLauncher != null) {
            try {
                if (!initialLauncher.getCanonicalFile().equals(targetLauncher.getCanonicalFile())) {
                    initialLauncher.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            descriptor.removeFile(initialLauncher);
        }
        descriptor.addFile(targetLauncher);
    }

    private void brandSolaris(ExecutablesDescriptor descriptor) throws Exception {
        this.renameLauncher(descriptor);
        if (!this.brandIcons) {
            return;
        }
        File root = descriptor.getLocation();
        int i = 0;
        while (i < this.icons.length) {
            String extension;
            String icon = this.icons[i];
            int iconNameLength = icon.length();
            if (iconNameLength >= 5 && (extension = icon.substring(iconNameLength - 5)).charAt(0) == '.' && extension.endsWith(".pm") && "lmst".indexOf(extension.charAt(1)) >= 0) {
                File targetIcon = new File(root, String.valueOf(this.name) + extension);
                Utils.copy((File)new File(icon), (File)targetIcon);
                descriptor.addFile(targetIcon);
            }
            ++i;
        }
    }

    private void brandWindows(ExecutablesDescriptor descriptor) throws Exception {
        Logger logger = PDEPlugin.getLogger();
        File root = descriptor.getLocation();
        String targetLauncherName = String.valueOf(this.name) + ".exe";
        File templateLauncher = null;
        String[] stringArray = new String[]{targetLauncherName, "launcher.exe", "eclipse.exe"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String launcherName = stringArray[n2];
            File launcher = new File(root, launcherName);
            if (launcher.exists()) {
                templateLauncher = launcher;
                break;
            }
            ++n2;
        }
        if (this.brandIcons) {
            if (templateLauncher != null) {
                String[] args = new String[this.icons.length + 1];
                args[0] = templateLauncher.getAbsolutePath();
                System.arraycopy(this.icons, 0, args, 1, this.icons.length);
                IconExe.main((String[])args);
            } else {
                logger.warning("Could not find executable to brand.", new Object[0]);
            }
        }
        File targetLauncher = new File(root, targetLauncherName);
        if (templateLauncher != null && !templateLauncher.getName().equals(targetLauncherName)) {
            templateLauncher.renameTo(targetLauncher);
            descriptor.replace(templateLauncher, targetLauncher);
        }
        descriptor.setExecutableName(this.name, true);
    }

    private void copyMacIni(ExecutablesDescriptor descriptor, File initialRoot, File target, String iconName) {
        int xdoc;
        StringBuffer buffer;
        Logger logger = PDEPlugin.getLogger();
        String brandedIniName = "MacOS/" + this.name + ".ini";
        File targetFile = this.getCanonicalFile(new File(target, brandedIniName));
        File brandedIni = this.getCanonicalFile(new File(initialRoot, brandedIniName));
        File ini = this.getCanonicalFile(new File(initialRoot, "MacOS/eclipse.ini"));
        File ini2 = this.getCanonicalFile(new File(initialRoot, "MacOS/Eclipse.ini"));
        if (targetFile.exists()) {
            if (brandedIni.exists() && !brandedIni.equals(targetFile)) {
                brandedIni.delete();
                descriptor.removeFile(brandedIni);
            }
            if (ini.exists() && !ini.equals(targetFile)) {
                ini.delete();
                descriptor.removeFile(ini);
            }
            if (ini2.exists() && !ini2.equals(targetFile)) {
                ini2.delete();
                descriptor.removeFile(ini2);
            }
            ini = targetFile;
        } else if (brandedIni.exists()) {
            if (ini.exists() && !ini.equals(brandedIni)) {
                ini.delete();
                descriptor.removeFile(ini);
            }
            if (ini2.exists() && !ini2.equals(brandedIni)) {
                ini2.delete();
                descriptor.removeFile(ini2);
            }
            ini = brandedIni;
        } else if (ini.exists()) {
            if (ini2.exists() && !ini2.equals(ini)) {
                logger.warning("Found both %s and %s - discarding the latter", new Object[]{ini.getAbsolutePath(), ini2.getAbsolutePath()});
                ini2.delete();
                descriptor.removeFile(ini2);
            }
        } else if (ini2.exists()) {
            ini = ini2;
        } else {
            return;
        }
        try {
            buffer = this.readFile(ini);
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Impossible to brand ini file", new Object[0]);
            return;
        }
        if (iconName.length() > 0 && (xdoc = this.scan(buffer, 0, XDOC_ICON)) != -1) {
            String icns = XDOC_ICON.replaceFirst("Eclipse.icns", iconName);
            buffer.replace(xdoc, xdoc + XDOC_ICON.length(), icns);
        }
        try {
            this.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(targetFile));
            if (!ini.equals(targetFile)) {
                ini.delete();
                descriptor.replace(ini, targetFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Throwable)e, "Impossible to brand ini file", new Object[0]);
            return;
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Impossible to brand ini file", new Object[0]);
            return;
        }
    }

    private void copyMacLauncher(ExecutablesDescriptor descriptor, File initialRoot, File target) {
        Logger logger = PDEPlugin.getLogger();
        File launcher = this.getCanonicalFile(new File(initialRoot, "MacOS/launcher"));
        File eclipseLauncher = this.getCanonicalFile(new File(initialRoot, "MacOS/eclipse"));
        File targetFile = this.getCanonicalFile(new File(target, "MacOS/" + this.name));
        if (!launcher.exists()) {
            launcher = eclipseLauncher;
        } else if (eclipseLauncher.exists() && !targetFile.equals(eclipseLauncher)) {
            eclipseLauncher.delete();
            descriptor.removeFile(eclipseLauncher);
        }
        if (!targetFile.equals(launcher)) {
            try {
                Utils.copy((File)launcher, (File)targetFile);
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Could not copy macosx launcher", new Object[0]);
                return;
            }
            launcher.delete();
            descriptor.replace(launcher, targetFile);
        }
        descriptor.setExecutableName(this.name, false);
    }

    private File findLauncher(File root) {
        String[] stringArray = new String[]{"launcher", "eclipse"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String launcherName = stringArray[n2];
            File launcher = new File(root, launcherName);
            if (launcher.exists()) {
                return launcher;
            }
            ++n2;
        }
        return null;
    }

    private File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    private void modifyInfoPListFile(ExecutablesDescriptor descriptor, File initialRoot, File target2, String iconName) {
        StringBuffer buffer;
        Logger logger = PDEPlugin.getLogger();
        File infoPList = new File(initialRoot, "Info.plist");
        try {
            buffer = this.readFile(infoPList);
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Impossible to brand info.plist file", new Object[0]);
            return;
        }
        int exePos = this.scan(buffer, 0, MARKER_NAME);
        if (exePos != -1) {
            buffer.replace(exePos, exePos + MARKER_NAME.length(), this.name);
        } else {
            exePos = this.scan(buffer, 0, MARKER_KEY);
            if (exePos != -1) {
                int start = this.scan(buffer, exePos + MARKER_KEY.length(), STRING_START);
                int end = this.scan(buffer, start + STRING_START.length(), STRING_END);
                if (start > -1 && end > start) {
                    buffer.replace(start + STRING_START.length(), end, this.name);
                }
            }
        }
        int bundlePos = this.scan(buffer, 0, BUNDLE_NAME);
        if (bundlePos != -1) {
            buffer.replace(bundlePos, bundlePos + BUNDLE_NAME.length(), this.name);
        } else {
            exePos = this.scan(buffer, 0, BUNDLE_KEY);
            if (exePos != -1) {
                int start = this.scan(buffer, exePos + BUNDLE_KEY.length(), STRING_START);
                int end = this.scan(buffer, start + STRING_START.length(), STRING_END);
                if (start > -1 && end > start) {
                    buffer.replace(start + STRING_START.length(), end, this.name);
                }
            }
        }
        int iconPos = this.scan(buffer, 0, ICON_NAME);
        if (iconPos != -1) {
            buffer.replace(iconPos, iconPos + ICON_NAME.length(), iconName);
        } else {
            exePos = this.scan(buffer, 0, ICON_KEY);
            if (exePos != -1) {
                int start = this.scan(buffer, exePos + ICON_KEY.length(), STRING_START);
                int end = this.scan(buffer, start + STRING_START.length(), STRING_END);
                if (start > -1 && end > start) {
                    buffer.replace(start + STRING_START.length(), end, iconName);
                }
            }
        }
        File target = new File(target2, "Info.plist");
        try {
            target.getParentFile().mkdirs();
            this.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(target));
        }
        catch (FileNotFoundException e) {
            logger.error((Throwable)e, "Impossible to brand info.plist file", new Object[0]);
            return;
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Impossible to brand info.plist file", new Object[0]);
            return;
        }
        try {
            if (!infoPList.getCanonicalFile().equals(target.getCanonicalFile())) {
                infoPList.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        descriptor.replace(infoPList, target);
    }

    private void moveContents(ExecutablesDescriptor descriptor, File source, File target) {
        Logger logger = PDEPlugin.getLogger();
        if (!source.exists()) {
            return;
        }
        try {
            source = source.getCanonicalFile();
            target = target.getCanonicalFile();
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Could not copy macosx resources.", new Object[0]);
            return;
        }
        if (source.equals(target)) {
            return;
        }
        target.getParentFile().mkdirs();
        if (source.isDirectory()) {
            this.moveDirectoryContents(descriptor, source, target);
        } else {
            source.renameTo(target);
            descriptor.replace(source, target);
        }
    }

    private void moveDirectoryContents(ExecutablesDescriptor descriptor, File sourceDirectory, File targetDirectory) {
        targetDirectory.mkdir();
        File[] contents = sourceDirectory.listFiles();
        int i = 0;
        while (i < contents.length) {
            File dest = new File(targetDirectory, contents[i].getName());
            if (contents[i].isDirectory()) {
                this.moveDirectoryContents(descriptor, contents[i], dest);
            } else {
                contents[i].renameTo(dest);
                descriptor.replace(contents[i], dest);
            }
            ++i;
        }
        sourceDirectory.delete();
    }

    private StringBuffer readFile(File targetName) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(targetName)));
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        try {
            int count = reader.read(buf, 0, buf.length);
            while (count != -1) {
                result.append(buf, 0, count);
                count = reader.read(buf, 0, buf.length);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private void renameLauncher(ExecutablesDescriptor descriptor) {
        File root = descriptor.getLocation();
        File launcher = this.findLauncher(root);
        if (launcher == null) {
            return;
        }
        File targetLauncher = new File(root, this.name);
        launcher.renameTo(targetLauncher);
        descriptor.replace(launcher, targetLauncher);
        descriptor.setExecutableName(this.name, true);
    }

    private int scan(StringBuffer buf, int start, String targetName) {
        return this.scan(buf, start, new String[]{targetName});
    }

    private int scan(StringBuffer buf, int start, String[] targets) {
        int i = start;
        while (i < buf.length()) {
            int j = 0;
            while (j < targets.length) {
                String match;
                if (i < buf.length() - targets[j].length() && targets[j].equalsIgnoreCase(match = buf.substring(i, i + targets[j].length()))) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    private void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead == -1) {
                    break;
                }
                destination.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }
}

