/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.ITeamReaderType;
import org.eclipse.buckminster.pde.MatchRule;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.tasks.VersionConsolidator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class BundleConsolidator
extends VersionConsolidator {
    private final byte[] bytes;

    public static IVersionedId getVersionedId(Manifest manifest) throws BundleException {
        Attributes a = manifest.getMainAttributes();
        String symbolicName = a.getValue("Bundle-SymbolicName");
        if (symbolicName == null) {
            return null;
        }
        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName);
        String id = elements[0].getValue();
        Version version = null;
        String versionStr = a.getValue("Bundle-Version");
        if (versionStr != null) {
            try {
                version = Version.parseVersion((String)versionStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new VersionedId(id, version);
    }

    public BundleConsolidator(File inputFile, File outputFile, File propertiesFile, String qualifier) throws CoreException {
        super(outputFile, propertiesFile, qualifier);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(inputFile);
                IOUtils.copy((InputStream)input, (OutputStream)output, null);
            }
            catch (IOException e) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_manifest_from_0, (Object)inputFile), (Object[])new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        this.bytes = output.toByteArray();
    }

    public void run() throws CoreException, IOException {
        IActionContext ctx = AbstractActor.getActiveContext();
        Manifest manifest = new Manifest(new ByteArrayInputStream(this.bytes));
        Attributes a = manifest.getMainAttributes();
        String symbolicName = a.getValue("Bundle-SymbolicName");
        String id = null;
        Version newVersion = null;
        boolean changed = false;
        if (symbolicName != null) {
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName);
                id = elements[0].getValue();
            }
            catch (BundleException be) {
                throw new IOException(be.getMessage(), be);
            }
            String versionStr = a.getValue("Bundle-Version");
            if (versionStr != null) {
                try {
                    Version version = Version.parseVersion((String)versionStr);
                    ComponentIdentifier ci = new ComponentIdentifier(id, "osgi.bundle", version);
                    newVersion = this.replaceQualifier(ci, Collections.emptyList());
                    if (newVersion != null && !version.equals(newVersion)) {
                        a.put(new Attributes.Name("Bundle-Version"), newVersion.toString());
                        changed = true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        changed = this.fixRequiredBundleVersions(ctx, a) || changed;
        changed = this.addSourceReference(ctx, a) || changed;
        changed = this.treatManifest(manifest, id, newVersion) || changed;
        OutputStream out = null;
        try {
            out = new FileOutputStream(this.getOutputFile());
            if (changed) {
                out = new BufferedOutputStream(out);
                manifest.write(out);
            } else {
                ((OutputStream)out).write(this.bytes);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)out);
    }

    protected boolean addSourceReference(IActionContext ctx, Attributes a) throws CoreException, IOException {
        if (!this.getBooleanProperty("generateSourceReferences", false)) {
            return false;
        }
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(ctx.getComponentLocation());
        if (container == null) {
            return false;
        }
        IReaderType rd = AbstractReaderType.getTypeForResource((IResource)container);
        if (!(rd instanceof ITeamReaderType)) {
            return false;
        }
        String sourceRef = ((ITeamReaderType)rd).getSourceReference((IResource)container, (IProgressMonitor)new NullProgressMonitor());
        if (sourceRef == null) {
            return false;
        }
        a.putValue("Eclipse-SourceReferences", sourceRef);
        return true;
    }

    protected boolean fixRequiredBundleVersions(IActionContext ctx, Attributes a) throws IOException {
        String requiredBundles = a.getValue("Require-Bundle");
        if (requiredBundles == null) {
            return false;
        }
        if (!this.getBooleanProperty("pde.bundle.range.generation", true)) {
            return false;
        }
        Map props = this.getProperties();
        MatchRule matchRule = MatchRule.COMPATIBLE;
        String tmp = (String)props.get("pde.match.rule.bundle");
        if (tmp == null) {
            tmp = (String)props.get("pde.match.rule.default");
        }
        if (tmp != null) {
            matchRule = MatchRule.getMatchRule(tmp);
        }
        if (matchRule == MatchRule.NONE) {
            return false;
        }
        MatchRule matchRuleLower = MatchRule.EQUIVALENT;
        tmp = (String)props.get("pde.match.rule.bundle.lower");
        if (tmp == null && (tmp = (String)props.get("pde.match.rule.default.lower")) == null && "true".equalsIgnoreCase(tmp = (String)props.get("pde.match.rule.retain.lower"))) {
            tmp = "perfect";
        }
        if (tmp != null) {
            matchRuleLower = MatchRule.getMatchRule(tmp);
        }
        boolean changed = false;
        StringBuilder bld = new StringBuilder();
        try {
            boolean firstElement = true;
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Require-Bundle", (String)requiredBundles);
            int n = manifestElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    ManifestElement element = manifestElementArray[n2];
                    if (firstElement) {
                        firstElement = false;
                    } else {
                        bld.append(',');
                    }
                    bld.append(element);
                    if (element.getAttribute("bundle-version") == null) {
                        Version v = null;
                        try {
                            CSpec cspec = ctx.getGlobalContext().findCSpec((ICSpecData)ctx.getCSpec(), new ComponentRequest(element.getValue(), "osgi.bundle", null));
                            v = cspec.getVersion();
                        }
                        catch (CoreException e) {
                            break block17;
                        }
                        if (v != null && !v.equals(Version.emptyVersion)) {
                            VersionRange range = CSpecGenerator.createRuleBasedRange(matchRule, matchRuleLower, v);
                            changed = true;
                            bld.append(';');
                            bld.append("bundle-version");
                            bld.append('=');
                            bld.append('\"');
                            bld.append(range);
                            bld.append('\"');
                        }
                    }
                }
                ++n2;
            }
        }
        catch (BundleException be) {
            throw new IOException(be.getMessage(), be);
        }
        if (changed) {
            a.putValue("Require-Bundle", bld.toString());
        }
        return changed;
    }

    protected boolean treatManifest(Manifest manifest, String symbolicName, Version version) throws IOException {
        return false;
    }
}

