/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlesAction
extends org.eclipse.equinox.p2.publisher.eclipse.BundlesAction {
    private final Map<IVersionedId, CSpec> cspecs;

    public BundlesAction(File[] locations, Map<IVersionedId, CSpec> cspecs) {
        super(locations);
        this.cspecs = cspecs;
    }

    protected void generateBundleIUs(BundleDescription[] bundleDescriptions, IPublisherInfo publisherInfo, IPublisherResult result, IProgressMonitor monitor) {
        Map props = AbstractActor.getActiveContext().getProperties();
        String buildId = (String)props.get("build.id");
        if (buildId != null) {
            BundleDescription[] bundleDescriptionArray = bundleDescriptions;
            int n = bundleDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundleDescription = bundleDescriptionArray[n2];
                this.createBuildIdAdvice(bundleDescription, publisherInfo, buildId);
                ++n2;
            }
        }
        super.generateBundleIUs(bundleDescriptions, publisherInfo, result, monitor);
    }

    private void createBuildIdAdvice(BundleDescription bundleDescription, IPublisherInfo publisherInfo, String buildId) {
        if (bundleDescription == null) {
            return;
        }
        CSpec cspec = this.findCSpec(bundleDescription);
        if (cspec == null) {
            return;
        }
        if (cspec.getAttribute("about.mappings") != null) {
            BundlePropertyAdvice advice = new BundlePropertyAdvice(bundleDescription.getSymbolicName(), org.eclipse.equinox.p2.metadata.Version.create((String)bundleDescription.getVersion().toString()));
            advice.put("buckminster.build.id", buildId);
            publisherInfo.addAdvice((IPublisherAdvice)advice);
        }
    }

    private CSpec findCSpec(BundleDescription bundleDescription) {
        String id = bundleDescription.getSymbolicName();
        Version v = bundleDescription.getVersion();
        Integer major = v.getMajor();
        Integer minor = v.getMinor();
        Integer micro = v.getMicro();
        for (Map.Entry<IVersionedId, CSpec> entry : this.cspecs.entrySet()) {
            org.eclipse.equinox.p2.metadata.Version vnv;
            IVersionedId vn = entry.getKey();
            if (!id.equals(vn.getId()) || (vnv = vn.getVersion()) == null || vnv.getSegmentCount() <= 3 || !major.equals(vnv.getSegment(0)) || !minor.equals(vnv.getSegment(1)) || !micro.equals(vnv.getSegment(2))) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BundlePropertyAdvice
    extends HashMap<String, String>
    implements IPropertyAdvice {
        private final String id;
        private final org.eclipse.equinox.p2.metadata.Version version;

        public BundlePropertyAdvice(String id, org.eclipse.equinox.p2.metadata.Version version) {
            this.id = id;
            this.version = version;
        }

        public Map<String, String> getArtifactProperties(IInstallableUnit iu, IArtifactDescriptor descriptor) {
            return null;
        }

        public Map<String, String> getInstallableUnitProperties(MetadataFactory.InstallableUnitDescription iu) {
            return this;
        }

        public boolean isApplicable(String configSpec, boolean includeDefault, String candidateId, org.eclipse.equinox.p2.metadata.Version candidateVersion) {
            return this.id.equals(candidateId) && (this.version == null || this.version.equals(candidateVersion));
        }
    }
}

