/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.tasks.FeatureVersionSuffixGenerator;
import org.eclipse.buckminster.pde.tasks.SiteReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteIU;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoriesAction
extends AbstractPublisherAction {
    private static final String PROP_CATEGORY_DESCRIPTION_PREFIX = "category.description.";
    private static final String PROP_CATEGORY_MEMBERS_PREFIX = "category.members.";
    private static final String PROP_CATEGORY_DEFAULT = "category.default";
    private static final String PROP_CATEGORY_ID_PREFIX = "category.id.";
    private static final String HIDDEN_CATEGORY_ID = "hidden_category";
    private static final Pattern idAndVersionPattern = Pattern.compile("^(\\S)_([0-9]+(?:\\.[0-9]+){0,2}(?:\\.[A-Za-z0-9_-]))$");
    private static final List<Category> defaultCategoryList;
    private final Map<Locale, Map<String, String>> localizations;
    private final Map<String, String> buildProperties;
    private final List<IVersionedId> featureEntries;
    private final File projectRoot;

    static {
        Category defaultCategory = new Category("Default");
        defaultCategory.setDescription("Default category for otherwise uncategorized features");
        defaultCategory.setLabel("Uncategorized");
        defaultCategoryList = Collections.singletonList(defaultCategory);
    }

    private static Map<Locale, Map<String, String>> getLocalizations(Map<String, String> properties, File featureRoot) {
        if (featureRoot == null || properties == null) {
            return Collections.emptyMap();
        }
        ArrayList<String> msgKeys = null;
        for (String value : properties.values()) {
            if (value == null || value.length() <= 1 || value.charAt(0) != '%') continue;
            if (msgKeys == null) {
                msgKeys = new ArrayList<String>();
            }
            msgKeys.add(value.substring(1));
        }
        if (msgKeys == null) {
            return Collections.emptyMap();
        }
        String[] keyStrings = msgKeys.toArray(new String[msgKeys.size()]);
        Map localizations = featureRoot.isDirectory() ? LocalizationHelper.getDirPropertyLocalizations((File)featureRoot, (String)"feature", null, (String[])keyStrings) : (featureRoot.getName().endsWith(".jar") ? LocalizationHelper.getJarPropertyLocalizations((File)featureRoot, (String)"feature", null, (String[])keyStrings) : Collections.emptyMap());
        return localizations;
    }

    private static boolean isKeyReference(String value, String key) {
        return value != null && value.length() > 1 && value.charAt(0) == '%' && value.substring(1).equals(key);
    }

    public CategoriesAction(File projectRoot, Map<String, String> buildProperties, List<IVersionedId> featureEntries) throws CoreException {
        this.buildProperties = buildProperties;
        this.localizations = CategoriesAction.getLocalizations(buildProperties, projectRoot);
        this.featureEntries = featureEntries;
        this.projectRoot = projectRoot;
    }

    public IInstallableUnit createCategoryIU(Category category, Set<IInstallableUnit> featureIUs, IInstallableUnit parentCategory) {
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = category.getName();
        cat.setId(categoryId);
        cat.setProperty("org.eclipse.equinox.p2.name", category.getLabel());
        cat.setProperty("org.eclipse.equinox.p2.description", category.getDescription());
        ArrayList<IVersionedId> fts = new ArrayList<IVersionedId>(featureIUs.size());
        ArrayList<IVersionedId> bds = new ArrayList<IVersionedId>(featureIUs.size());
        ArrayList<IRequirement> reqsConfigurationUnits = new ArrayList<IRequirement>(featureIUs.size());
        for (IInstallableUnit iu : featureIUs) {
            VersionedId vn = new VersionedId(iu.getId(), iu.getVersion());
            if (iu.getId().endsWith(".feature.group")) {
                fts.add((IVersionedId)vn);
            } else {
                bds.add((IVersionedId)vn);
            }
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (IMatchExpression)iu.getFilter(), (boolean)false, (boolean)false));
        }
        FeatureVersionSuffixGenerator suffixGen = new FeatureVersionSuffixGenerator(-1, -1);
        Version categoryVersion = Version.createOSGi((int)0, (int)0, (int)1, (String)suffixGen.generateSuffix(fts, bds));
        cat.setVersion(categoryVersion);
        if (parentCategory != null) {
            reqsConfigurationUnits.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)parentCategory.getId(), (VersionRange)VersionRange.emptyRange, (IMatchExpression)parentCategory.getFilter(), (boolean)false, (boolean)false));
        }
        cat.setRequirements((IRequirement[])reqsConfigurationUnits.toArray(new IRequiredCapability[reqsConfigurationUnits.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)categoryId, (Version)categoryVersion));
        for (Map.Entry<Locale, Map<String, String>> locEntry : this.localizations.entrySet()) {
            Locale locale = locEntry.getKey();
            for (Map.Entry<String, String> entry : locEntry.getValue().entrySet()) {
                String key = entry.getKey();
                if (!CategoriesAction.isKeyReference(category.getLabel(), key) && !CategoriesAction.isKeyReference(category.getDescription(), key)) continue;
                cat.setProperty(String.valueOf(locale.toString()) + '.' + key, entry.getValue());
            }
            providedCapabilities.add(PublisherHelper.makeTranslationCapability((String)categoryId, (Locale)locale));
        }
        cat.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        Map<IInstallableUnit, List<Category>> featuresToCategories;
        HashMap<Category, Set<IInstallableUnit>> categoriesToFeatureIUs = new HashMap<Category, Set<IInstallableUnit>>();
        try {
            featuresToCategories = this.getFeatureToCategoryMappings(publisherInfo, results, monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        for (Map.Entry<IInstallableUnit, List<Category>> entry : featuresToCategories.entrySet()) {
            IInstallableUnit iu = entry.getKey();
            for (Category category : entry.getValue()) {
                HashSet<IInstallableUnit> featureIUs = (HashSet<IInstallableUnit>)categoriesToFeatureIUs.get(category);
                if (featureIUs == null) {
                    featureIUs = new HashSet<IInstallableUnit>();
                    categoriesToFeatureIUs.put(category, featureIUs);
                }
                featureIUs.add(iu);
            }
        }
        this.generateCategoryIUs(categoriesToFeatureIUs, results);
        return Status.OK_STATUS;
    }

    private StringBuilder collectIDs(Set<IInstallableUnit> iUs) {
        StringBuilder strBuilder = new StringBuilder();
        Iterator<IInstallableUnit> iterator = iUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iInstallableUnit = iterator.next();
            strBuilder.append(iInstallableUnit.getId());
            if (!iterator.hasNext()) continue;
            strBuilder.append(", ");
        }
        return strBuilder;
    }

    private void generateCategoryIUs(Map<Category, Set<IInstallableUnit>> categoriesToFeatures, IPublisherResult result) {
        for (Map.Entry<Category, Set<IInstallableUnit>> entry : categoriesToFeatures.entrySet()) {
            Category category = entry.getKey();
            Set<IInstallableUnit> iUs = entry.getValue();
            if (!HIDDEN_CATEGORY_ID.equals(category.getName())) {
                result.addIU(this.createCategoryIU(category, iUs, null), "non_root");
                continue;
            }
            if (!PDEPlugin.getLogger().isDebugEnabled()) continue;
            StringBuilder strBuilder = this.collectIDs(iUs);
            PDEPlugin.getLogger().debug("Category %s is used. Following features will be hidden in categorized view: %s", new Object[]{HIDDEN_CATEGORY_ID, strBuilder.toString()});
        }
    }

    private IInstallableUnit getFeatureIU(String name, Version version, IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String id = String.valueOf(name) + ".feature.group";
        IQuery query = null;
        if (version == null || version.equals(Version.emptyVersion)) {
            query = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)id));
        } else {
            String qual = VersionHelper.getQualifier((Version)version);
            if (qual != null && qual.contains("qualifier")) {
                Version low = VersionHelper.replaceQualifier((Version)version, null);
                org.osgi.framework.Version ov = new org.osgi.framework.Version(version.toString());
                query = QueryUtil.createIUQuery((String)id, (VersionRange)new VersionRange(low, true, Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)(ov.getMicro() + 1)), false));
            } else {
                query = QueryUtil.createIUQuery((String)id, (Version)version);
            }
            query = QueryUtil.createLimitQuery((IQuery)query, (int)1);
        }
        IQueryResult result = results.query(query, monitor);
        if (result.isEmpty()) {
            result = publisherInfo.getMetadataRepository().query(query, null);
        }
        if (result.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            result = publisherInfo.getContextMetadataRepository().query(query, null);
        }
        if (!result.isEmpty()) {
            return (IInstallableUnit)result.iterator().next();
        }
        return null;
    }

    private Map<IInstallableUnit, List<Category>> getFeatureToCategoryMappings(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) throws CoreException {
        Category cat;
        Category cat2;
        String id;
        String key;
        HashMap<IInstallableUnit, List<Category>> mappings = new HashMap<IInstallableUnit, List<Category>>();
        HashMap<String, Category> categories = new HashMap<String, Category>();
        for (Map.Entry<String, String> entry : this.buildProperties.entrySet()) {
            key = entry.getKey();
            if (!key.startsWith(PROP_CATEGORY_ID_PREFIX)) continue;
            id = key.substring(PROP_CATEGORY_ID_PREFIX.length());
            cat2 = (Category)categories.get(id);
            if (cat2 == null) {
                cat2 = new Category(id);
                categories.put(id, cat2);
            }
            cat2.setLabel(entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.buildProperties.entrySet()) {
            key = entry.getKey();
            if (key.startsWith(PROP_CATEGORY_DESCRIPTION_PREFIX)) {
                id = key.substring(PROP_CATEGORY_DESCRIPTION_PREFIX.length());
                cat2 = (Category)categories.get(id);
                if (cat2 == null) continue;
                cat2.setDescription(entry.getValue());
                continue;
            }
            if (!key.startsWith(PROP_CATEGORY_MEMBERS_PREFIX) || (cat2 = (Category)categories.get(id = key.substring(PROP_CATEGORY_MEMBERS_PREFIX.length()))) == null) continue;
            String[] stringArray = TextUtils.splitAndTrim((String)entry.getValue(), (String)",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu;
                String name = stringArray[n2];
                Version version = null;
                Matcher m = idAndVersionPattern.matcher(name);
                if (m.matches()) {
                    name = m.group(1);
                    version = Version.create((String)m.group(2));
                }
                if ((iu = this.getFeatureIU(name, version, publisherInfo, results, monitor)) != null) {
                    List<Category> catList = mappings.get(iu);
                    if (catList == null) {
                        catList = new ArrayList<Category>();
                        mappings.put(iu, catList);
                        catList.add(cat2);
                    } else if (!catList.contains(cat2)) {
                        catList.add(cat2);
                    }
                }
                ++n2;
            }
        }
        List<Category> defaultCategories = defaultCategoryList;
        String defaultCategory = this.buildProperties.get(PROP_CATEGORY_DEFAULT);
        if (defaultCategory != null && (cat = (Category)categories.get(defaultCategory)) != null) {
            defaultCategories = Collections.singletonList(cat);
        }
        try {
            SiteModel site = SiteReader.getSite(new File(this.projectRoot, "category.xml"));
            SiteFeature[] siteFeatureArray = site.getFeatures();
            int n = siteFeatureArray.length;
            int cat3 = 0;
            while (cat3 < n) {
                block31: {
                    SiteFeature feature = siteFeatureArray[cat3];
                    IInstallableUnit iu = this.getFeatureIU(feature.getFeatureIdentifier(), Version.create((String)feature.getFeatureVersion()), publisherInfo, results, monitor);
                    if (iu == null) break block31;
                    String[] stringArray = feature.getCategoryNames();
                    int n3 = stringArray.length;
                    int version = 0;
                    while (version < n3) {
                        block33: {
                            List<Category> catList;
                            Category cat4;
                            block32: {
                                String id2 = stringArray[version];
                                cat4 = (Category)categories.get(id2);
                                if (cat4 != null) break block32;
                                SiteCategory siteCat = site.getCategory(id2);
                                if (siteCat == null) break block33;
                                cat4 = new Category(id2);
                                cat4.setDescription(siteCat.getDescription());
                                cat4.setLabel(siteCat.getLabel());
                                categories.put(id2, cat4);
                            }
                            if ((catList = mappings.get(iu)) == null) {
                                catList = new ArrayList<Category>();
                                mappings.put(iu, catList);
                                catList.add(cat4);
                            } else if (!catList.contains(cat4)) {
                                catList.add(cat4);
                            }
                        }
                        ++version;
                    }
                }
                ++cat3;
            }
            siteFeatureArray = site.getIUs();
            n = siteFeatureArray.length;
            cat3 = 0;
            while (cat3 < n) {
                SiteFeature siteIU = siteFeatureArray[cat3];
                for (IInstallableUnit iu : this.getIUs((SiteIU)siteIU, publisherInfo, results)) {
                    String[] stringArray = siteIU.getCategoryNames();
                    int n4 = stringArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        block35: {
                            List<Category> catList;
                            Category cat5;
                            block34: {
                                String id3 = stringArray[n5];
                                cat5 = (Category)categories.get(id3);
                                if (cat5 != null) break block34;
                                SiteCategory siteCat = site.getCategory(id3);
                                if (siteCat == null) break block35;
                                cat5 = new Category(id3);
                                cat5.setDescription(siteCat.getDescription());
                                cat5.setLabel(siteCat.getLabel());
                                categories.put(id3, cat5);
                            }
                            if ((catList = mappings.get(iu)) == null) {
                                catList = new ArrayList<Category>();
                                mappings.put(iu, catList);
                                catList.add(cat5);
                            } else if (!catList.contains(cat5)) {
                                catList.add(cat5);
                            }
                        }
                        ++n5;
                    }
                }
                ++cat3;
            }
        }
        catch (FileNotFoundException site) {
            // empty catch block
        }
        for (IVersionedId fe : this.featureEntries) {
            IInstallableUnit iu = this.getFeatureIU(fe.getId(), fe.getVersion(), publisherInfo, results, monitor);
            if (iu == null || mappings.containsKey(iu)) continue;
            mappings.put(iu, defaultCategories);
        }
        return mappings;
    }

    private Collection<IInstallableUnit> getIUs(SiteIU siteIU, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = siteIU.getID();
        String range = siteIU.getRange();
        String type = siteIU.getQueryType();
        String expression = siteIU.getQueryExpression();
        Object[] params = siteIU.getQueryParams();
        if (id == null && (type == null || expression == null)) {
            return CollectionUtils.emptyList();
        }
        IQuery query = null;
        if (id != null) {
            VersionRange vRange = new VersionRange(range);
            query = QueryUtil.createIUQuery((String)id, (VersionRange)vRange);
        } else if (type.equals("context")) {
            query = QueryUtil.createQuery((String)expression, (Object[])params);
        } else if (type.equals("match")) {
            query = QueryUtil.createMatchQuery((String)expression, (Object[])params);
        }
        if (query == null) {
            return CollectionUtils.emptyList();
        }
        IQueryResult queryResult = results.query(query, null);
        if (queryResult.isEmpty()) {
            queryResult = publisherInfo.getMetadataRepository().query(query, null);
        }
        if (queryResult.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            queryResult = publisherInfo.getContextMetadataRepository().query(query, null);
        }
        return queryResult.toUnmodifiableSet();
    }

    private static class Category {
        private String description;
        private String label;
        private final String name;

        Category(String name) {
            this.name = name;
        }

        public boolean equals(Object value) {
            return value instanceof Category && ((Category)value).name.equals(this.name);
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

