/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.File;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.pde.tasks.BrandingIron;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.eclipse.IBrandingAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;

public class EquinoxExecutableAction
extends org.eclipse.equinox.p2.publisher.eclipse.EquinoxExecutableAction {
    private static String peruseIcons(IBrandingAdvice advice) {
        String[] iconsArr = advice.getIcons();
        if (iconsArr == null || iconsArr.length == 0) {
            return null;
        }
        if (!(advice instanceof ProductFileAdvice)) {
            return TextUtils.concat((String[])iconsArr, (String)",");
        }
        IProductDescriptor productFile = ((ProductFileAdvice)advice).getProductFile();
        File root = productFile.getLocation().getParentFile();
        if (root != null) {
            root = root.getParentFile();
        }
        if (root == null) {
            return TextUtils.concat((String[])iconsArr, (String)",");
        }
        IPath rootPath = Path.fromOSString((String)root.getAbsolutePath());
        int idx = iconsArr.length;
        while (--idx >= 0) {
            File iconFile = new File(iconsArr[idx]);
            if (iconFile.isFile()) continue;
            IPath iconPath = Path.fromOSString((String)iconFile.getPath());
            if (rootPath.isPrefixOf(iconPath)) {
                iconPath = iconPath.removeFirstSegments(rootPath.segmentCount() + 1).setDevice(null).makeRelative();
                IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(iconPath.segment(0));
                IResource iconRes = prj.findMember(iconPath.removeFirstSegments(1));
                iconPath = iconRes != null && iconRes.exists() ? iconRes.getLocation() : rootPath.append(iconPath);
            } else {
                iconPath = rootPath.append(iconPath.makeRelative());
            }
            iconFile = iconPath.toFile();
            if (!iconFile.isFile()) continue;
            iconsArr[idx] = iconFile.getAbsolutePath();
        }
        return TextUtils.concat((String[])iconsArr, (String)",");
    }

    public EquinoxExecutableAction(ExecutablesDescriptor executables, String configSpec, String idBase, Version version, String flavor) {
        super(executables, configSpec, idBase, version, flavor);
    }

    protected void fullBrandExecutables(ExecutablesDescriptor descriptor, IBrandingAdvice advice) {
        String name;
        BrandingIron iron = new BrandingIron();
        String icons = EquinoxExecutableAction.peruseIcons(advice);
        if (icons != null) {
            iron.setIcons(icons);
        }
        if ((name = advice.getExecutableName()) == null) {
            name = "eclipse";
        }
        if ("macosx".equals(advice.getOS())) {
            StringBuilder appNameBld = new StringBuilder();
            appNameBld.append(Character.toUpperCase(name.charAt(0)));
            appNameBld.append(name, 1, name.length());
            name = appNameBld.toString();
        }
        iron.setName(name);
        iron.setOS(advice.getOS());
        try {
            iron.brand(descriptor);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

