/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.pde.cspecgen.feature.CSpecFromFeature;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.pde.internal.model.EditableFeatureModel;
import org.eclipse.buckminster.pde.tasks.GroupConsolidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureConsolidator
extends GroupConsolidator
implements IModelChangedListener {
    private final EditableFeatureModel featureModel;

    public FeatureConsolidator(File inputFile, File outputFile, File propertiesFile, List<File> featuresAndBundles, String qualifier, boolean generateVersionSuffix, int maxVersionSuffixLength, int significantDigits) throws CoreException {
        super(outputFile, propertiesFile, featuresAndBundles, qualifier, generateVersionSuffix, maxVersionSuffixLength, significantDigits);
        this.featureModel = FeatureModelReader.readEditableFeatureModel(inputFile);
        this.featureModel.addModelChangedListener(this);
    }

    public void modelChanged(IModelChangedEvent event) {
        this.featureModel.setDirty(true);
    }

    public void run() throws CoreException, FileNotFoundException {
        String nvstr;
        ComponentIdentifier cid;
        Version version;
        IFeature feature = this.featureModel.getFeature();
        String id = feature.getId();
        IFeatureChild sourceRef = null;
        Map<String, Version[]> featureVers = this.getFeatureVersions();
        ArrayList<ComponentIdentifier> deps = new ArrayList<ComponentIdentifier>();
        IFeatureChild[] iFeatureChildArray = feature.getIncludedFeatures();
        int n = iFeatureChildArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild ref = iFeatureChildArray[n2];
            String vstr = ref.getVersion();
            String refId = ref.getId();
            String refIdWOS = CSpecFromFeature.getIdWithoutSource(refId);
            if (refIdWOS != null && refIdWOS.equals(id)) {
                sourceRef = ref;
            } else {
                version = FeatureConsolidator.findBestVersion(featureVers, id, "feature", refId, vstr);
                if (version != null) {
                    cid = new ComponentIdentifier(refId, "eclipse.feature", version);
                    deps.add(cid);
                    nvstr = cid.getVersion().toString();
                    if (!nvstr.equals(vstr)) {
                        ref.setVersion(nvstr);
                    }
                }
            }
            ++n2;
        }
        Map<String, Version[]> pluginVers = this.getPluginVersions();
        IFeaturePlugin[] iFeaturePluginArray = feature.getPlugins();
        int n3 = iFeaturePluginArray.length;
        n = 0;
        while (n < n3) {
            IFeaturePlugin ref = iFeaturePluginArray[n];
            String vstr = ref.getVersion();
            String refId = ref.getId();
            version = FeatureConsolidator.findBestVersion(pluginVers, id, "plugin", refId, vstr);
            if (version != null) {
                cid = new ComponentIdentifier(refId, "osgi.bundle", version);
                deps.add(cid);
                nvstr = cid.getVersion().toString();
                if (!nvstr.equals(vstr)) {
                    ref.setVersion(nvstr);
                }
            }
            ++n;
        }
        this.consolidateFeatureVersion(deps);
        if (sourceRef != null) {
            sourceRef.setVersion(feature.getVersion());
        }
        this.featureModel.save(this.getOutputFile());
    }

    private void consolidateFeatureVersion(List<ComponentIdentifier> deps) throws CoreException {
        List<IVersionedId> bundleList;
        List<IVersionedId> featureList;
        int lastDot;
        Version version;
        IFeature feature = this.featureModel.getFeature();
        String versionStr = feature.getVersion();
        if (versionStr == null) {
            return;
        }
        try {
            version = Version.parseVersion((String)versionStr);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (versionStr.endsWith("qualifier")) {
            ComponentIdentifier ci = new ComponentIdentifier(feature.getId(), "eclipse.feature", version);
            Version newVersion = this.replaceQualifier(ci, deps);
            if (newVersion != null && !version.equals(newVersion)) {
                String newVersionStr = newVersion.toString();
                feature.setVersion(newVersionStr);
                if (this.isContextReplacement()) {
                    lastDot = versionStr.lastIndexOf(".");
                    this.featureModel.setContextQualifierLength(newVersionStr.length() - lastDot - 1);
                }
                version = newVersion;
            }
            if (this.isUsingGenerator(ci)) {
                return;
            }
        }
        if (this.featureModel.getContextQualifierLength() == -1) {
            return;
        }
        IFeatureChild[] features = feature.getIncludedFeatures();
        if (features.length == 0) {
            featureList = Collections.emptyList();
        } else {
            featureList = new ArrayList(features.length);
            IFeatureChild[] iFeatureChildArray = features;
            int n = features.length;
            lastDot = 0;
            while (lastDot < n) {
                IFeatureChild f = iFeatureChildArray[lastDot];
                featureList.add((IVersionedId)new VersionedId(f.getId(), f.getVersion()));
                ++lastDot;
            }
        }
        IFeatureImport[] bundles = feature.getImports();
        if (features.length == 0) {
            bundleList = Collections.emptyList();
        } else {
            bundleList = new ArrayList(bundles.length);
            IFeatureImport[] iFeatureImportArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureImport f = iFeatureImportArray[n2];
                bundleList.add((IVersionedId)new VersionedId(f.getId(), f.getVersion()));
                ++n2;
            }
        }
        String suffix = this.generateFeatureVersionSuffix(featureList, bundleList);
        if (suffix == null) {
            return;
        }
        String qualifier = VersionHelper.getQualifier((Version)version);
        if (qualifier == null) {
            qualifier = suffix;
        } else {
            StringBuilder bld = new StringBuilder();
            bld.append(qualifier, 0, this.featureModel.getContextQualifierLength());
            bld.append('-');
            bld.append(suffix);
            qualifier = bld.toString();
        }
        feature.setVersion(VersionHelper.replaceQualifier((Version)version, (String)qualifier).toString());
    }
}

