/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.publisher.FileSetDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.pde.internal.build.Config;

public class FeatureRootAdvice
extends AbstractAdvice {
    private static final File[] noFiles = new File[0];
    private final Map<String, ConfigAdvice> advice = new HashMap<String, ConfigAdvice>();
    private final String featureId;

    public FeatureRootAdvice(String featureId) {
        this.featureId = featureId;
    }

    public ConfigAdvice getConfigAdvice(String config) {
        ConfigAdvice configAdvice = this.advice.get(config);
        if (configAdvice == null) {
            configAdvice = new ConfigAdvice(config);
            this.advice.put(config, configAdvice);
        }
        return configAdvice;
    }

    public String[] getConfigs() {
        return this.advice.keySet().toArray(new String[this.advice.size()]);
    }

    public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
        return !(configSpec != null && !this.advice.containsKey(configSpec) || id != null && !this.featureId.equals(id));
    }

    public static class ConfigAdvice
    implements FileUtils.IPathComputer {
        private Map<File, String> files;
        private final FileSetDescriptor descriptor;

        ConfigAdvice(String config) {
            this.descriptor = config.length() == 0 || config.equals(Config.ANY) ? new FileSetDescriptor("root", null) : new FileSetDescriptor("root." + config, config);
        }

        public void addRootfile(File sourceFile, String destDir) {
            if (this.files == null) {
                this.files = new HashMap<File, String>();
            }
            this.files.put(sourceFile, destDir);
        }

        public IPath computePath(File source) {
            String destDir;
            if (this.files != null && (destDir = this.files.get(source)) != null) {
                return Path.fromPortableString((String)destDir).append(source.getName());
            }
            return null;
        }

        public FileSetDescriptor getDescriptor() {
            return this.descriptor;
        }

        public File[] getFiles() {
            if (this.files != null) {
                Set<File> fileSet = this.files.keySet();
                return fileSet.toArray(new File[fileSet.size()]);
            }
            return noFiles;
        }

        public void reset() {
        }
    }
}

