/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.MapUnion;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.pde.MatchRule;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.tasks.CapabilityAdvice;
import org.eclipse.buckminster.pde.tasks.FeatureRootAdvice;
import org.eclipse.buckminster.pde.tasks.VersionConsolidator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.core.helpers.StringHelper;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.publisher.FileSetDescriptor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesAction
extends org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction {
    private static final Project PROPERTY_REPLACER = new Project();
    private final Map<IVersionedId, CSpec> cspecs;
    private final Map<IVersionedId, Map<String, String>> properties = new HashMap<IVersionedId, Map<String, String>>();
    private final Map<IVersionedId, File> adviceFiles = new HashMap<IVersionedId, File>();

    private static FeatureRootAdvice createRootAdvice(String featureId, Properties buildProperties, IPath baseDirectory, String[] configs) {
        Map entry;
        Map configMap = Utils.processRootProperties((Properties)buildProperties, (boolean)true);
        if (configMap.size() == 1 && (entry = (Map)configMap.get("!!COMMON!!")) != null && entry.isEmpty()) {
            return null;
        }
        FeatureRootAdvice advice = new FeatureRootAdvice(featureId);
        for (Map.Entry entry2 : configMap.entrySet()) {
            String config = (String)entry2.getKey();
            Map rootMap = (Map)entry2.getValue();
            FeaturesAction.populateConfigAdvice(advice, config, rootMap, baseDirectory, configs);
        }
        return advice;
    }

    private static void populateConfigAdvice(FeatureRootAdvice advice, String config, Map<String, String> rootMap, IPath baseDirectory, String[] configs) {
        if (config.equals("!!COMMON!!")) {
            config = "";
        } else {
            config = FeaturesAction.reorderConfig(config);
            int idx = configs.length;
            while (--idx >= 0) {
                if (config.equals(configs[idx])) break;
            }
            if (idx < 0) {
                return;
            }
        }
        FeatureRootAdvice.ConfigAdvice configAdvice = advice.getConfigAdvice(config);
        FileSetDescriptor descriptor = configAdvice.getDescriptor();
        ArrayList<String> permissionsKeys = new ArrayList<String>();
        for (Map.Entry<String, String> rootEntry : rootMap.entrySet()) {
            String key = rootEntry.getKey();
            if (key.equals("!!ROOT.LINK!!")) {
                descriptor.setLinks(rootEntry.getValue());
                continue;
            }
            if (key.startsWith("!!ROOT.PERMISSIONS!!")) {
                permissionsKeys.add(key);
                continue;
            }
            String[] stringArray = StringHelper.getArrayFromString((String)rootEntry.getValue(), (char)',');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isFile;
                String rootValue = stringArray[n2];
                String rootName = rootValue;
                boolean isAbsolute = rootName.startsWith("absolute:");
                if (isAbsolute) {
                    rootName = rootName.substring(9);
                }
                if (isFile = rootName.startsWith("file:")) {
                    rootName = rootName.substring(5);
                }
                if (rootName.length() != 0) {
                    IPath basePath;
                    String pattern;
                    IPath rootPath = Path.fromPortableString((String)rootName);
                    int firstStar = -1;
                    int numSegs = rootPath.segmentCount();
                    int idx = 0;
                    while (idx < numSegs) {
                        if (rootPath.segment(idx).indexOf(42) >= 0) {
                            firstStar = idx;
                            break;
                        }
                        ++idx;
                    }
                    if (firstStar == -1) {
                        if (isFile) {
                            pattern = rootPath.lastSegment();
                            basePath = rootPath.removeLastSegments(1);
                        } else {
                            pattern = "**";
                            basePath = rootPath;
                        }
                    } else {
                        basePath = rootPath.removeLastSegments(rootPath.segmentCount() - (firstStar + 1));
                        pattern = rootPath.removeFirstSegments(firstStar).toPortableString();
                    }
                    if (!isAbsolute) {
                        basePath = baseDirectory.append(basePath.makeRelative());
                    }
                    FileSet fileset = new FileSet();
                    fileset.setProject(PROPERTY_REPLACER);
                    fileset.setErrorOnMissingDir(false);
                    File base = basePath.toFile();
                    fileset.setDir(base);
                    PatternSet.NameEntry include = fileset.createInclude();
                    include.setName(pattern);
                    String[] files = fileset.getDirectoryScanner().getIncludedFiles();
                    if (files.length == 0) {
                        PDEPlugin.getLogger().warning(NLS.bind((String)Messages.rootAdviceForConfig_0_in_1_at_2_does_not_appoint_existing_artifacts, (Object[])new Object[]{config, "build.properties", baseDirectory.toOSString()}), new Object[0]);
                    } else {
                        IPath destBaseDir = Path.fromPortableString((String)key);
                        String[] stringArray2 = files;
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String found = stringArray2[n4];
                            IPath foundFile = Path.fromOSString((String)found);
                            String destDir = destBaseDir.append(foundFile.removeLastSegments(1)).toPortableString();
                            configAdvice.addRootfile(new File(base, found), destDir);
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        for (String permissionKey : permissionsKeys) {
            String permissionString = rootMap.get(permissionKey);
            String[] names = StringHelper.getArrayFromString((String)permissionString, (char)',');
            OrSelector orSelector = new OrSelector();
            orSelector.setProject(PROPERTY_REPLACER);
            Object[] objectArray = names;
            int n = names.length;
            int n5 = 0;
            while (n5 < n) {
                String name = objectArray[n5];
                if ("${launcherName}.app/Contents/MacOS/${launcherName}".equals(name)) {
                    name = "Eclipse.app/Contents/MacOS/launcher";
                }
                FilenameSelector nameSelector = new FilenameSelector();
                nameSelector.setProject(PROPERTY_REPLACER);
                nameSelector.setName(name);
                orSelector.addFilename(nameSelector);
                ++n5;
            }
            permissionKey = permissionKey.substring("!!ROOT.PERMISSIONS!!".length());
            objectArray = configAdvice.getFiles();
            n = objectArray.length;
            n5 = 0;
            while (n5 < n) {
                Object file = objectArray[n5];
                IPath finalFilePath = configAdvice.computePath((File)file);
                if (orSelector.isSelected(null, finalFilePath.toOSString(), null)) {
                    descriptor.addPermissions(new String[]{permissionKey, finalFilePath.toPortableString()});
                }
                ++n5;
            }
        }
    }

    private static String reorderConfig(String config) {
        String[] parsed = StringHelper.getArrayFromString((String)config, (char)'.');
        return String.valueOf(parsed[1]) + '.' + parsed[0] + '.' + parsed[2];
    }

    public FeaturesAction(File[] featureBinaries, Map<IVersionedId, CSpec> cspecs) {
        super(featureBinaries);
        this.cspecs = cspecs;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        for (Map.Entry<IVersionedId, CSpec> entry : this.cspecs.entrySet()) {
            CSpec cspec = entry.getValue();
            try {
                IVersionedId vn;
                IPath location;
                block10: {
                    location = cspec.getComponentLocation();
                    if (!location.hasTrailingSeparator()) continue;
                    vn = entry.getKey();
                    vn = new VersionedId(vn.getId(), VersionHelper.replaceQualifier((Version)vn.getVersion(), null));
                    File buildProps = location.append("build.properties").toFile();
                    BufferedInputStream input = null;
                    Properties props = new Properties();
                    try {
                        input = new BufferedInputStream(new FileInputStream(buildProps));
                        props.load(input);
                        this.properties.put(vn, (Map<String, String>)new BMProperties(props));
                        FeatureRootAdvice rootAdvice = FeaturesAction.createRootAdvice(cspec.getName(), props, location, publisherInfo.getConfigurations());
                        if (rootAdvice != null) {
                            publisherInfo.addAdvice((IPublisherAdvice)rootAdvice);
                        }
                    }
                    catch (FileNotFoundException rootAdvice) {
                        IOUtils.close(input);
                        break block10;
                    }
                    catch (IOException e) {
                        try {
                            throw BuckminsterException.wrap((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.close(input);
                            throw throwable;
                        }
                    }
                    IOUtils.close((Closeable)input);
                }
                File adviceFile = location.append("p2.inf").toFile();
                if (!adviceFile.canRead()) continue;
                this.adviceFiles.put(vn, adviceFile);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return super.perform(publisherInfo, results, monitor);
    }

    protected void generateFeatureIUs(Feature[] featureList, IPublisherResult result) {
        Feature[] featureArray = featureList;
        int n = featureList.length;
        int n2 = 0;
        while (n2 < n) {
            Feature feature = featureArray[n2];
            this.addCapabilityAdvice(feature);
            ++n2;
        }
        super.generateFeatureIUs(featureList, result);
    }

    protected ArrayList<IInstallableUnit> generateRootFileIUs(Feature feature, IPublisherResult result, IPublisherInfo publisherInfo) {
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        Collection collection = publisherInfo.getAdvice(null, false, feature.getId(), Version.parseVersion((String)feature.getVersion()), FeatureRootAdvice.class);
        if (collection.isEmpty()) {
            return ius;
        }
        for (FeatureRootAdvice advice : collection) {
            String[] configs = advice.getConfigs();
            int i = 0;
            while (i < configs.length) {
                IInstallableUnit iu;
                Collection keys;
                File[] files;
                String config = configs[i];
                FeatureRootAdvice.ConfigAdvice configAdvice = advice.getConfigAdvice(config);
                if (configAdvice != null && (files = configAdvice.getFiles()).length != 0 && !(keys = (iu = this.createFeatureRootFileIU(feature.getId(), feature.getVersion(), null, configAdvice.getDescriptor())).getArtifacts()).isEmpty()) {
                    IArtifactKey artifactKey = (IArtifactKey)keys.iterator().next();
                    ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor(artifactKey);
                    this.publishArtifact((IArtifactDescriptor)artifactDescriptor, files, null, publisherInfo, configAdvice);
                    result.addIU(iu, "non_root");
                    ius.add(iu);
                }
                ++i;
            }
        }
        return ius;
    }

    protected void generateSiteReferences(Feature feature, IPublisherResult result, IPublisherInfo publisherInfo) {
    }

    private void addCapabilityAdvice(Feature feature) {
        boolean requirementGreedy;
        Version v = Version.parseVersion((String)feature.getVersion());
        VersionedId vn = new VersionedId(feature.getId(), VersionHelper.replaceQualifier((Version)v, null));
        Map<String, String> localProps = this.properties.get(vn);
        File adviceFile = this.adviceFiles.get(vn);
        if (adviceFile != null) {
            this.info.addAdvice((IPublisherAdvice)new AdviceFileAdvice(String.valueOf(feature.getId()) + ".feature.group", v, Path.fromOSString((String)adviceFile.getParent()), Path.fromOSString((String)adviceFile.getName())));
        }
        Map props = AbstractActor.getActiveContext().getProperties();
        if (localProps != null) {
            props = new MapUnion(localProps, props);
        }
        if (props == null || !VersionConsolidator.getBooleanProperty(props, "pde.feature.range.generation", true)) {
            return;
        }
        MatchRule matchRuleLower = MatchRule.PERFECT;
        MatchRule matchRule = MatchRule.PERFECT;
        String tmp = (String)props.get("pde.match.rule.feature.lower");
        if (tmp != null) {
            matchRuleLower = MatchRule.getMatchRule(tmp);
        }
        if ((tmp = (String)props.get("pde.match.rule.feature")) != null) {
            matchRule = MatchRule.getMatchRule(tmp);
        }
        if ((requirementGreedy = VersionConsolidator.getBooleanProperty(props, "pde.feature.requirements.greedy", true)) && (matchRule == MatchRule.NONE || matchRule == MatchRule.PERFECT)) {
            return;
        }
        CapabilityAdvice advice = new CapabilityAdvice(String.valueOf(feature.getId()) + ".feature.group", v);
        FeatureEntry[] entries = feature.getEntries();
        int idx = entries.length;
        while (--idx >= 0) {
            VersionRange range;
            int min;
            Version version;
            FeatureEntry entry = entries[idx];
            if (entry.isPatch()) continue;
            String id = entry.getId();
            if (!entry.isPlugin()) {
                id = String.valueOf(id) + ".feature.group";
            }
            if ((version = Version.create((String)entry.getVersion())) == null || version.equals(Version.emptyVersion)) {
                version = null;
            }
            int n = min = entry.isOptional() ? 0 : 1;
            if (entry.isRequires()) {
                if (requirementGreedy) continue;
                range = CSpecGenerator.createRuleBasedRange(MatchRule.getMatchRule(entry.getMatch()), MatchRule.PERFECT, version);
                advice.addRequirement(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, this.getFilter(entry), (int)min, (int)1, (boolean)false));
                continue;
            }
            if (version == null || matchRule == MatchRule.NONE || matchRule == MatchRule.PERFECT) continue;
            range = CSpecGenerator.createRuleBasedRange(matchRule, matchRuleLower, version);
            advice.addRequirement(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, this.getFilter(entry), (int)min, (int)1, (boolean)true));
        }
        if (!advice.isEmpty()) {
            this.info.addAdvice((IPublisherAdvice)advice);
        }
    }

    private void expandFilter(String filter, String osgiFilterValue, StringBuilder result) {
        String[] filters = StringHelper.getArrayFromString((String)filter, (char)',');
        if (filters.length > 1) {
            result.append("(|");
        }
        int idx = 0;
        while (idx < filters.length) {
            result.append('(');
            result.append(osgiFilterValue);
            result.append('=');
            result.append(filters[0]);
            result.append(')');
            ++idx;
        }
        if (filters.length > 1) {
            result.append(')');
        }
    }

    private IMatchExpression<IInstallableUnit> getFilter(FeatureEntry entry) {
        StringBuilder result = new StringBuilder();
        result.append("(&");
        if (entry.getFilter() != null) {
            result.append(entry.getFilter());
        }
        this.expandFilter(entry.getOS(), "osgi.os", result);
        this.expandFilter(entry.getWS(), "osgi.ws", result);
        this.expandFilter(entry.getArch(), "osgi.arch", result);
        this.expandFilter(entry.getNL(), "osgi.nl", result);
        if (result.length() == 2) {
            return null;
        }
        result.append(')');
        return InstallableUnit.parseFilter((String)result.toString());
    }
}

