/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.buckminster.ant.tasks.VersionQualifierTask;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.pde.internal.model.EditableFeatureModel;
import org.eclipse.buckminster.pde.internal.model.ExternalBundleModel;
import org.eclipse.buckminster.pde.tasks.FeatureVersionSuffixGenerator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GroupConsolidator
extends VersionQualifierTask
implements IPDEConstants,
IBuildPropertiesConstants {
    private final File outputFile;
    private final FeatureVersionSuffixGenerator suffixGenerator;
    private final Map<String, Version[]> pluginVersions = new HashMap<String, Version[]>();
    private final Map<String, Version[]> featureVersions = new HashMap<String, Version[]>();

    static void addVersion(Map<String, Version[]> versionMap, String id, String versionStr) {
        if (versionStr == null) {
            return;
        }
        Version version = Version.parseVersion((String)versionStr);
        Version[] arr = versionMap.get(id);
        if (arr == null) {
            arr = new Version[]{version};
        } else {
            Version[] versionArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                Version old = versionArray[n2];
                if (old.equals(version)) {
                    return;
                }
                ++n2;
            }
            Version[] newArr = new Version[arr.length + 1];
            System.arraycopy(arr, 0, newArr, 0, arr.length);
            newArr[arr.length] = version;
            arr = newArr;
        }
        versionMap.put(id, arr);
    }

    static Version findBestVersion(Map<String, Version[]> versionMap, String id, String componentType, String refId, String vstr) throws CoreException {
        Version version = Version.create((String)vstr);
        if (version != null && Version.emptyVersion.equals(version)) {
            version = null;
        }
        Version candidate = null;
        Version[] versions = versionMap.get(refId);
        if (versions != null) {
            Version[] versionArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                Version v = versionArray[n2];
                if (v != null) {
                    if (version == null) {
                        if (candidate == null || v.compareTo((Object)candidate) > 0) {
                            candidate = v;
                        }
                    } else if (VersionHelper.equalsUnqualified((Version)version, (Version)v) && (candidate == null || v.compareTo((Object)candidate) > 0)) {
                        candidate = v;
                    }
                }
                ++n2;
            }
        }
        if (candidate == null) {
            String idWithoutSource = null;
            if (refId.endsWith(".source")) {
                idWithoutSource = refId.substring(0, refId.length() - 7);
            } else if (refId.endsWith(".source.feature")) {
                idWithoutSource = String.valueOf(refId.substring(0, refId.length() - 15)) + ".feature";
            }
            if (idWithoutSource != null) {
                candidate = GroupConsolidator.findBestVersion(versionMap, id, componentType, idWithoutSource, vstr);
            }
            if (candidate == null) {
                candidate = version;
            }
        }
        return candidate;
    }

    static InputStream getInput(File dirOrZip, String fileName) throws CoreException, FileNotFoundException {
        if (dirOrZip.isDirectory()) {
            return new BufferedInputStream(new FileInputStream(new File(dirOrZip, fileName)));
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(dirOrZip);
            JarEntry entry = jarFile.getJarEntry(fileName);
            if (entry == null) {
                throw new FileNotFoundException(String.format("%s[%s]", dirOrZip, fileName));
            }
            final JarFile innerJarFile = jarFile;
            jarFile = null;
            FilterInputStream filterInputStream = new FilterInputStream(innerJarFile.getInputStream(entry)){

                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    innerJarFile.close();
                }
            };
            return filterInputStream;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw BuckminsterException.fromMessage((Throwable)e, (String)NLS.bind((String)Messages.unable_to_read_0, (Object)dirOrZip), (Object[])new Object[0]);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    PDEPlugin.getLogger().error((Throwable)e, NLS.bind((String)Messages.error_while_closing_0, (Object)dirOrZip), new Object[0]);
                }
            }
        }
    }

    GroupConsolidator(File outputFile, File propertiesFile, List<File> featuresAndBundles, String qualifier, boolean generateVersionSuffix, int maxVersionSuffixLength, int significantDigits) throws CoreException {
        super(propertiesFile, qualifier);
        this.outputFile = outputFile;
        this.suffixGenerator = generateVersionSuffix ? new FeatureVersionSuffixGenerator(this.getIntProperty("generatedVersionLength", maxVersionSuffixLength), this.getIntProperty("significantVersionDigits", significantDigits)) : null;
        for (File featureOrBundle : featuresAndBundles) {
            IPluginBase pb;
            Object model2;
            InputStream input = null;
            try {
                input = GroupConsolidator.getInput(featureOrBundle, "feature.xml");
                model2 = FeatureModelReader.readFeatureModel(input);
                IFeature feature = model2.getFeature();
                String id = feature.getId();
                String version = feature.getVersion();
                if (version == null) continue;
                int ctxQualLen = -1;
                if (version.indexOf(45) > 0) {
                    IOUtils.close((Closeable)input);
                    input = GroupConsolidator.getInput(featureOrBundle, "feature.xml");
                    ctxQualLen = EditableFeatureModel.getContextQualifierLength(input);
                }
                if (this.suffixGenerator != null) {
                    this.suffixGenerator.addContextQualifierLength(id, ctxQualLen);
                }
                GroupConsolidator.addVersion(this.featureVersions, id, version);
                continue;
            }
            catch (FileNotFoundException model2) {
            }
            finally {
                IOUtils.close((Closeable)input);
                input = null;
            }
            try {
                input = GroupConsolidator.getInput(featureOrBundle, "META-INF/MANIFEST.MF");
                model2 = new ExternalBundleModel(featureOrBundle);
                model2.load(input, true);
                BundleFragmentModel bmodel = model2.isFragmentModel() ? new BundleFragmentModel() : new BundlePluginModel();
                bmodel.setEnabled(true);
                bmodel.setBundleModel((IBundleModel)model2);
                IPluginBase pb2 = bmodel.getPluginBase();
                GroupConsolidator.addVersion(this.pluginVersions, pb2.getId(), pb2.getVersion());
                continue;
            }
            catch (FileNotFoundException model3) {
            }
            finally {
                IOUtils.close((Closeable)input);
                input = null;
            }
            try {
                input = GroupConsolidator.getInput(featureOrBundle, "plugin.xml");
                model2 = new ExternalPluginModel();
                model2.load(input, true);
                pb = model2.getPluginBase();
                GroupConsolidator.addVersion(this.pluginVersions, pb.getId(), pb.getVersion());
                continue;
            }
            catch (FileNotFoundException model4) {
            }
            finally {
                IOUtils.close((Closeable)input);
                input = null;
            }
            try {
                input = GroupConsolidator.getInput(featureOrBundle, "fragment.xml");
                model2 = new ExternalFragmentModel();
                model2.load(input, true);
                pb = model2.getPluginBase();
                GroupConsolidator.addVersion(this.pluginVersions, pb.getId(), pb.getVersion());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                IOUtils.close((Closeable)input);
            }
        }
    }

    String generateFeatureVersionSuffix(List<IVersionedId> features, List<IVersionedId> bundles) throws CoreException {
        return this.suffixGenerator == null ? null : this.suffixGenerator.generateSuffix(features, bundles);
    }

    Map<String, Version[]> getFeatureVersions() {
        return this.featureVersions;
    }

    int getIntProperty(String property, int defaultValue) {
        int result = defaultValue;
        Object value = this.getProperties().get(property);
        if (value instanceof String) {
            try {
                result = Integer.parseInt((String)value);
                if (result < 1) {
                    result = defaultValue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    File getOutputFile() {
        return this.outputFile;
    }

    Map<String, Version[]> getPluginVersions() {
        return this.pluginVersions;
    }
}

