/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.pde.tasks.JNLPModel;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class JNLPGenerator {
    private String codeBase = "$$codebase";
    private final IFeature feature;
    private String href;
    private boolean offLineAllowed = true;
    private String specVersion = "1.5+";
    private boolean useVersions = true;

    public static String convertArch(String arch) {
        if (arch == null) {
            return null;
        }
        if ("x86".equalsIgnoreCase(arch)) {
            return "x86";
        }
        if ("PA_RISC".equalsIgnoreCase(arch)) {
            return "PA_RISC";
        }
        if ("ppc".equalsIgnoreCase(arch)) {
            return "ppc";
        }
        if ("sparc".equalsIgnoreCase(arch)) {
            return "sparc";
        }
        if ("x86_64".equalsIgnoreCase(arch)) {
            return "x86_64";
        }
        if ("ia64".equalsIgnoreCase(arch)) {
            return "ia64";
        }
        if ("ia64_32".equalsIgnoreCase(arch)) {
            return "ia64_32";
        }
        return arch;
    }

    public static String convertOS(String os) {
        if (os == null) {
            return null;
        }
        if ("win32".equalsIgnoreCase(os)) {
            return "Windows";
        }
        if ("macosx".equalsIgnoreCase(os)) {
            return "Mac";
        }
        if ("linux".equalsIgnoreCase(os)) {
            return "Linux";
        }
        if ("solaris".equalsIgnoreCase(os)) {
            return "Solaris";
        }
        if ("hpux".equalsIgnoreCase(os)) {
            return "HP-UX";
        }
        if ("aix".equalsIgnoreCase(os)) {
            return "AIX";
        }
        return os;
    }

    public JNLPGenerator(File featureFile) throws CoreException, FileNotFoundException {
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(featureFile));
            IFeatureModel featureModel = FeatureModelReader.readFeatureModel(input);
            this.feature = featureModel.getFeature();
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
    }

    public JNLPGenerator(IFeature feature) {
        this.feature = feature;
    }

    public JNLPModel generateJNLP() throws CoreException {
        String os;
        IFeatureInfo description;
        JNLPModel jnlp = new JNLPModel();
        jnlp.setOffLineAllowed(this.offLineAllowed);
        jnlp.setCodeBase(this.codeBase);
        jnlp.setSpecVersion(this.specVersion);
        if (this.href == null) {
            this.href = this.createFileName(this.feature.getId(), this.feature.getVersion().toString(), ".jnlp");
        }
        jnlp.setHref(this.href);
        jnlp.setTitle(this.feature.getLabel());
        jnlp.setVendor(this.feature.getProviderName());
        if (this.useVersions) {
            jnlp.setVersion(this.feature.getVersion().toString());
        }
        if ((description = this.feature.getFeatureInfo(0)) != null) {
            jnlp.setDescription(description.getDescription());
        }
        Map<String, String> j2se = jnlp.createResource(null, null, null, "j2se");
        j2se.put("version", "1.5+");
        IFeatureChild[] iFeatureChildArray = this.feature.getIncludedFeatures();
        int n = iFeatureChildArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild include = iFeatureChildArray[n2];
            os = include.getOS();
            if (os == null) {
                os = include.getWS();
            }
            Map<String, String> extension = jnlp.createResource(String.valueOf(include.getId()) + "_F", JNLPGenerator.convertOS(os), JNLPGenerator.convertArch(include.getArch()), "extension");
            String name = this.createFileName(include.getId(), include.getVersion(), ".jnlp");
            extension.put("name", name);
            extension.put("href", "features/" + name);
            if (this.useVersions) {
                extension.put("version", include.getVersion());
            }
            ++n2;
        }
        iFeatureChildArray = this.feature.getPlugins();
        n = iFeatureChildArray.length;
        n2 = 0;
        while (n2 < n) {
            IFeatureChild plugin = iFeatureChildArray[n2];
            os = plugin.getOS();
            if (os == null) {
                os = plugin.getWS();
            }
            Map<String, String> jar = jnlp.createResource(String.valueOf(plugin.getId()) + "_B", JNLPGenerator.convertOS(os), JNLPGenerator.convertArch(plugin.getArch()), "jar");
            jar.put("href", "plugins/" + this.createFileName(plugin.getId(), plugin.getVersion(), ".jar"));
            if (this.useVersions) {
                jar.put("version", plugin.getVersion());
            }
            ++n2;
        }
        return jnlp;
    }

    public String getCodeBase() {
        return this.codeBase;
    }

    public String getHref() {
        return this.href;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public boolean isOffLineAllowed() {
        return this.offLineAllowed;
    }

    public void setCodeBase(String codeBase) {
        this.codeBase = codeBase;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setOffLineAllowed(boolean offLineAllowed) {
        this.offLineAllowed = offLineAllowed;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    private String createFileName(String id, String version, String extension) {
        StringBuilder bld = new StringBuilder();
        bld.append(id);
        if (!this.useVersions) {
            bld.append('_');
            bld.append(version);
        }
        bld.append(extension);
        return bld.toString();
    }
}

