/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.pde.tasks.SAXModel;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNLPModel
extends SAXModel {
    private String codeBase = "$$codebase";
    private String description;
    private String href = "$$name";
    private boolean offLineAllowed = true;
    private Map<String, Resource> resourceById = new HashMap<String, Resource>();
    private Map<String, List<Resource>> resourcesByPlatform = new LinkedHashMap<String, List<Resource>>();
    private String specVersion = "1.5+";
    private String title;
    private String vendor;
    private String version;

    public Map<String, Resource> getResources() {
        return this.resourceById;
    }

    public void setCodeBase(String codeBase) {
        this.codeBase = codeBase;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setOffLineAllowed(boolean offLineAllowed) {
        this.offLineAllowed = offLineAllowed;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        if (this.specVersion != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"spec", (String)this.specVersion);
        }
        if (this.codeBase != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"codebase", (String)this.codeBase);
        }
        if (this.version != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"version", (String)this.version);
        }
        if (this.href != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"href", (String)this.href);
        }
        JNLPModel.startElement(receiver, "jnlp", attrs);
        this.emitInformation(receiver);
        this.emitSecurity(receiver);
        JNLPModel.emitBooleanElement(receiver, "component-desc");
        this.emitResources(receiver);
        JNLPModel.endElement(receiver, "jnlp");
        receiver.endDocument();
    }

    Map<String, String> createResource(String id, String os, String arch, String tag) {
        Resource resource = new Resource(os, arch, tag);
        List<Resource> resources = this.resourcesByPlatform.get(resource.getKey());
        if (resources == null) {
            resources = new ArrayList<Resource>();
            this.resourcesByPlatform.put(resource.getKey(), resources);
        }
        resources.add(resource);
        if (id != null) {
            this.resourceById.put(id, resource);
        }
        return resource;
    }

    void emitInformation(ContentHandler receiver) throws SAXException {
        JNLPModel.startElement(receiver, "information");
        if (this.title != null) {
            JNLPModel.emitTextElement(receiver, "title", this.title);
        }
        if (this.vendor != null) {
            JNLPModel.emitTextElement(receiver, "vendor", this.vendor);
        }
        if (this.description != null) {
            JNLPModel.emitTextElement(receiver, "description", this.description);
        }
        if (this.offLineAllowed) {
            JNLPModel.emitBooleanElement(receiver, "offline-allowed");
        }
        JNLPModel.endElement(receiver, "information");
    }

    void emitResources(ContentHandler receiver) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        for (List<Resource> resourceList : this.resourcesByPlatform.values()) {
            int top = resourceList.size();
            if (top == 0) continue;
            Resource first = resourceList.get(0);
            if (first.getOs() != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"os", (String)first.getOs());
            }
            if (first.getArch() != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"arch", (String)first.getArch());
            }
            JNLPModel.startElement(receiver, "resources", attrs);
            int idx = 0;
            while (idx < top) {
                Resource resource = resourceList.get(idx);
                resource.toSax(receiver, null, null, resource.getDefaultTag());
                ++idx;
            }
            JNLPModel.endElement(receiver, "resources");
            attrs.clear();
        }
    }

    void emitSecurity(ContentHandler receiver) throws SAXException {
        JNLPModel.startElement(receiver, "security");
        JNLPModel.emitBooleanElement(receiver, "all-permissions");
        JNLPModel.endElement(receiver, "security");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Resource
    extends HashMap<String, String>
    implements ISaxableElement {
        private final String arch;
        private final String key;
        private final String os;
        private final String tag;

        Resource(String os, String arch, String tag) {
            this.os = os;
            this.arch = arch;
            this.tag = tag;
            StringBuilder bld = new StringBuilder();
            if (os != null) {
                bld.append(os);
            }
            bld.append('/');
            if (arch != null) {
                bld.append(arch);
            }
            this.key = bld.toString();
        }

        public String getArch() {
            return this.arch;
        }

        public String getDefaultTag() {
            return this.tag;
        }

        public String getKey() {
            return this.key;
        }

        public String getOs() {
            return this.os;
        }

        public void toSax(ContentHandler receiver, String namespace, String prefix, String localName) throws SAXException {
            AttributesImpl attrs = new AttributesImpl();
            for (Map.Entry attribute : this.entrySet()) {
                Utils.addAttribute((AttributesImpl)attrs, (String)((String)attribute.getKey()), (String)((String)attribute.getValue()));
            }
            JNLPModel.startElement(receiver, localName, attrs);
            JNLPModel.endElement(receiver, localName);
        }
    }
}

