/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.pde.tasks.SAXModel;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNLPVersionModel
extends SAXModel {
    private final ArrayList<Resource> resources = new ArrayList();

    private static void emitTextElements(ContentHandler receiver, String tag, List<String> values) throws SAXException {
        if (values != null) {
            for (String value : values) {
                JNLPVersionModel.emitTextElement(receiver, tag, value);
            }
        }
    }

    public Platform addPlatform(String file, String name, String versionId, String productVersionId) {
        Platform platform = new Platform(file, name, versionId, productVersionId);
        this.resources.add(platform);
        return platform;
    }

    public Resource addResource(String file, String name, String versionId) {
        Resource resource = new Resource(file, name, versionId);
        this.resources.add(resource);
        return resource;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        JNLPVersionModel.startElement(receiver, "jnlp-versions");
        for (Resource resource : this.resources) {
            resource.toSax(receiver, null, null, resource.getDefaultTag());
        }
        JNLPVersionModel.endElement(receiver, "jnlp-versions");
        receiver.endDocument();
    }

    public static class Platform
    extends Resource {
        private final String productVersionId;

        Platform(String file, String name, String versionId, String productVersionId) {
            super(file, name, versionId);
            this.productVersionId = productVersionId;
        }

        public String getDefaultTag() {
            return "platform";
        }

        void emitContent(ContentHandler receiver) throws SAXException {
            super.emitContent(receiver);
            JNLPVersionModel.emitTextElement(receiver, "product-version-id", this.productVersionId);
        }
    }

    public static class Resource
    implements ISaxableElement {
        private final String name;
        private final String file;
        private final String versionId;
        private List<String> oss;
        private List<String> archs;
        private List<String> locales;

        Resource(String file, String name, String versionId) {
            this.file = file;
            this.name = name;
            this.versionId = versionId;
        }

        public void addArch(String arch) {
            if (this.archs == null) {
                this.archs = new ArrayList<String>();
            }
            this.archs.add(arch);
        }

        public void addLocale(String locale) {
            if (this.locales == null) {
                this.locales = new ArrayList<String>();
            }
            this.locales.add(locale);
        }

        public void addOs(String os) {
            if (this.oss == null) {
                this.oss = new ArrayList<String>();
            }
            this.oss.add(os);
        }

        public String getDefaultTag() {
            return "resource";
        }

        public void toSax(ContentHandler receiver, String namespace, String prefix, String localName) throws SAXException {
            JNLPVersionModel.startElement(receiver, localName);
            this.emitContent(receiver);
            JNLPVersionModel.endElement(receiver, localName);
        }

        void emitContent(ContentHandler receiver) throws SAXException {
            JNLPVersionModel.startElement(receiver, "pattern");
            JNLPVersionModel.emitTextElement(receiver, "name", this.name);
            JNLPVersionModel.emitTextElement(receiver, "version-id", this.versionId);
            JNLPVersionModel.emitTextElements(receiver, "os", this.oss);
            JNLPVersionModel.emitTextElements(receiver, "arch", this.archs);
            JNLPVersionModel.emitTextElements(receiver, "locale", this.locales);
            JNLPVersionModel.endElement(receiver, "pattern");
            JNLPVersionModel.emitTextElement(receiver, "file", this.file);
        }
    }
}

