/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.tasks.ApplicationLauncherAction;
import org.eclipse.buckminster.pde.tasks.ProductVersionPatcher;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.IPDEBuildConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductAction
extends org.eclipse.equinox.p2.publisher.eclipse.ProductAction
implements IPDEBuildConstants {
    private static final String PROP_OSGI_INSTANCE_AREA_DEFAULT = "osgi.instance.area.default";

    public ProductAction(IActionContext actionContext, String src, IProductDescriptor productDesc, String flvor, File exeFeatureLocation) {
        super(src, (IProductDescriptor)new ProductVersionPatcher(productDesc, actionContext), flvor, exeFeatureLocation);
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        ((ProductVersionPatcher)this.product).setQueryable((IQueryable<IInstallableUnit>)results);
        PublisherResult innerResult = new PublisherResult();
        PublisherInfo innerInfo = new PublisherInfo();
        String[] configs = publisherInfo.getConfigurations();
        if (this.executablesFeatureLocation == null) {
            Logger log = Buckminster.getLogger();
            String availableConfig = String.valueOf(Platform.getWS()) + '.' + Platform.getOS() + '.' + Platform.getOSArch();
            boolean warningsPrinted = false;
            boolean availConfigFound = false;
            String[] stringArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                String config = stringArray[n2];
                if (config.equals(availableConfig)) {
                    availConfigFound = true;
                } else {
                    log.warning(NLS.bind((String)Messages.Missing_exe_launcher_for_config_0, (Object)config), new Object[0]);
                    warningsPrinted = true;
                }
                ++n2;
            }
            if (warningsPrinted) {
                log.warning(Messages.Suggest_install_launchers_feature, new Object[0]);
            }
            if (!availConfigFound) {
                return Status.OK_STATUS;
            }
            innerInfo.setConfigurations(new String[]{availableConfig});
            if (Platform.inDevelopmentMode()) {
                String ilProp = System.getProperty("eclipse.host.location");
                if (ilProp == null) {
                    log.warning(Messages.Please_use_selfhost_vmargs, new Object[0]);
                } else {
                    this.source = ilProp;
                }
            } else {
                this.source = TargetPlatform.getPlatformInstallLocation().getAbsolutePath();
            }
        } else {
            innerInfo.setConfigurations(configs);
        }
        innerInfo.setArtifactOptions(publisherInfo.getArtifactOptions());
        innerInfo.setArtifactRepository(publisherInfo.getArtifactRepository());
        innerInfo.setMetadataRepository(publisherInfo.getMetadataRepository());
        innerInfo.setContextArtifactRepository(publisherInfo.getContextArtifactRepository());
        innerInfo.setContextMetadataRepository(innerInfo.getContextMetadataRepository());
        IQueryable<IInstallableUnit> bundleScope = this.getTransitiveBundleScope(results);
        ConfigData dfltStartInfos = new ConfigData(null, null, null, null);
        block1: for (IInstallableUnit iu : results.getIUs(null, "root")) {
            String symbolicId = iu.getId();
            if (symbolicId.startsWith("org.eclipse.equinox.launcher")) {
                innerResult.addIU(iu, "root");
                continue;
            }
            if (this.product.useFeatures() && symbolicId.endsWith(".feature.group")) {
                String legacyId = symbolicId.substring(0, symbolicId.length() - 14);
                for (IVersionedId feature : this.product.getFeatures()) {
                    if (!legacyId.equals(feature.getId())) continue;
                    innerResult.addIU(iu, "root");
                    continue block1;
                }
            }
            for (BundleInfo configBi : this.product.getBundleInfos()) {
                if (!symbolicId.equals(configBi.getSymbolicName())) continue;
                Version configVer = null;
                if (configBi.getVersion() != null && (configVer = Version.parseVersion((String)configBi.getVersion())).equals(Version.emptyVersion)) {
                    configVer = null;
                }
                if (configVer != null && !configVer.equals(iu.getVersion())) continue;
                innerResult.addIU(iu, "root");
                continue block1;
            }
            BundleInfo[] bundleInfoArray = this.getDefaultStartInfo();
            int configVer = bundleInfoArray.length;
            int n = 0;
            while (n < configVer) {
                BundleInfo bi = bundleInfoArray[n];
                if (symbolicId.equals(bi.getSymbolicName()) && !bundleScope.query(QueryUtil.createIUQuery((IVersionedId)iu), monitor).isEmpty()) {
                    innerResult.addIU(iu, "root");
                    dfltStartInfos.addBundle(bi);
                    continue block1;
                }
                ++n;
            }
        }
        int dfltSICount = dfltStartInfos.getBundles().length;
        String[] stringArray = innerInfo.getConfigurations();
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String os;
            String configSpec = stringArray[n3];
            if (dfltSICount > 0) {
                innerInfo.addAdvice((IPublisherAdvice)new ConfigAdvice(dfltStartInfos, configSpec));
            }
            if ("macosx".equals(os = AbstractPublisherAction.parseConfigSpec((String)configSpec)[1])) {
                innerInfo.addAdvice((IPublisherAdvice)new InstanceAreaAdvice(configSpec, "@user.home/Documents/workspace"));
            } else {
                innerInfo.addAdvice((IPublisherAdvice)new InstanceAreaAdvice(configSpec, "@user.home/workspace"));
            }
            ++n3;
        }
        IStatus status = super.perform((IPublisherInfo)innerInfo, (IPublisherResult)innerResult, monitor);
        if (status.getSeverity() != 4) {
            results.merge((IPublisherResult)innerResult, 0);
        }
        return status;
    }

    protected IPublisherAction[] createActions(IPublisherResult results) {
        IPublisherAction[] actions = super.createActions(results);
        if (this.hasOtherInstanceAreaAdvice()) {
            List adviceList = ((PublisherInfo)this.info).getAdvice();
            int idx = adviceList.size();
            while (--idx >= 0) {
                IPublisherAdvice advice = (IPublisherAdvice)adviceList.get(idx);
                if (!(advice instanceof InstanceAreaAdvice)) continue;
                adviceList.remove(idx);
            }
        }
        if (this.getExecutablesLocation() == null) {
            IPublisherAction[] newActions = new IPublisherAction[actions.length + 1];
            System.arraycopy(actions, 0, newActions, 1, actions.length);
            actions = newActions;
            actions[0] = this.createApplicationExecutableAction(this.info.getConfigurations());
        }
        return actions;
    }

    protected IPublisherAction createApplicationExecutableAction(String[] configSpecs) {
        return new ApplicationLauncherAction(this.id, this.version, this.flavor, this.executableName, this.getExecutablesLocation(), configSpecs);
    }

    protected boolean hasOtherInstanceAreaAdvice() {
        List adviceList = ((PublisherInfo)this.info).getAdvice();
        int idx = adviceList.size();
        while (--idx >= 0) {
            IAdditionalInstallableUnitAdvice iuAdvice;
            MetadataFactory.InstallableUnitDescription[] descs;
            IConfigAdvice pfAdvice;
            IPublisherAdvice advice = (IPublisherAdvice)adviceList.get(idx);
            if (advice instanceof IConfigAdvice && !(advice instanceof InstanceAreaAdvice) && (pfAdvice = (IConfigAdvice)advice).getProperties().containsKey(PROP_OSGI_INSTANCE_AREA_DEFAULT)) {
                return true;
            }
            if (advice instanceof ITouchpointAdvice) {
                String configString;
                ITouchpointData tpData = MetadataFactory.createTouchpointData(Collections.emptyMap());
                ITouchpointAdvice tpAdvice = (ITouchpointAdvice)advice;
                ITouchpointInstruction configure = (tpData = tpAdvice.getTouchpointData(tpData)).getInstruction("configure");
                if (configure instanceof ITouchpointInstruction && (configString = configure.getBody()).startsWith("setProgramProperty") && configString.contains(PROP_OSGI_INSTANCE_AREA_DEFAULT)) {
                    return true;
                }
            }
            if (!(advice instanceof IAdditionalInstallableUnitAdvice) || (descs = (iuAdvice = (IAdditionalInstallableUnitAdvice)advice).getAdditionalInstallableUnitDescriptions(null)) == null) continue;
            MetadataFactory.InstallableUnitDescription[] installableUnitDescriptionArray = descs;
            int n = descs.length;
            int n2 = 0;
            while (n2 < n) {
                MetadataFactory.InstallableUnitDescription desc = installableUnitDescriptionArray[n2];
                for (ITouchpointData tpData : desc.getTouchpointData()) {
                    String configString;
                    ITouchpointInstruction configure = tpData.getInstruction("configure");
                    if (!(configure instanceof ITouchpointInstruction) || !(configString = configure.getBody()).startsWith("setProgramProperty") || !configString.contains(PROP_OSGI_INSTANCE_AREA_DEFAULT)) continue;
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    IQueryable<IInstallableUnit> getTransitiveBundleScope(IPublisherResult results) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ArrayList<IInstallableUnit> roots = new ArrayList<IInstallableUnit>();
        if (!this.product.useFeatures()) {
            for (IVersionedId bundle : this.product.getBundles(false)) {
                VersionRange vr = VersionHelper.unqualifiedRange((Version)bundle.getVersion());
                IQuery iuQuery = QueryUtil.createIUQuery((String)bundle.getId(), (VersionRange)vr);
                Iterator itor = results.query(iuQuery, (IProgressMonitor)monitor).iterator();
                while (itor.hasNext()) {
                    roots.add((IInstallableUnit)itor.next());
                }
            }
        } else {
            for (IVersionedId feature : this.product.getFeatures()) {
                VersionRange vr = VersionHelper.unqualifiedRange((Version)feature.getVersion());
                IQuery iuQuery = QueryUtil.createIUQuery((String)(String.valueOf(feature.getId()) + ".feature.group"), (VersionRange)vr);
                Iterator itor = results.query(iuQuery, (IProgressMonitor)monitor).iterator();
                while (itor.hasNext()) {
                    roots.add((IInstallableUnit)itor.next());
                }
            }
        }
        IQuery traversal = QueryUtil.createQuery((String)"$0.traverse(set(), _, { rqCache, parent | parent.requirements.unique(rqCache).collect(rc | everything.select(iu | iu ~= rc)).flatten()})", (Object[])new Object[]{roots});
        return results.query(traversal, (IProgressMonitor)monitor);
    }

    private BundleInfo[] getDefaultStartInfo() {
        BundleInfo[] defaults = new BundleInfo[]{new BundleInfo("org.eclipse.equinox.simpleconfigurator", null, null, 1, true), new BundleInfo("org.eclipse.equinox.common", null, null, 2, true), new BundleInfo("org.eclipse.osgi", null, null, -1, true), new BundleInfo("org.eclipse.update.configurator", null, null, 4, true), new BundleInfo("org.eclipse.core.runtime", null, null, 4, true), new BundleInfo("org.eclipse.equinox.ds", null, null, 2, true)};
        return defaults;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InstanceAreaAdvice
    extends AbstractAdvice
    implements IConfigAdvice {
        private final String configSpec;
        private final String instanceArea;
        private static final BundleInfo[] noBundles = new BundleInfo[0];

        InstanceAreaAdvice(String configSpec, String instanceArea) {
            this.configSpec = configSpec;
            this.instanceArea = instanceArea;
        }

        public BundleInfo[] getBundles() {
            return noBundles;
        }

        public String getConfigSpec() {
            return this.configSpec;
        }

        public Map<String, String> getProperties() {
            return Collections.singletonMap(ProductAction.PROP_OSGI_INSTANCE_AREA_DEFAULT, this.instanceArea);
        }
    }
}

