/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductContentType;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductVersionPatcher
implements IProductDescriptor {
    private final IProductDescriptor product;
    private final IActionContext context;
    private IQueryable<IInstallableUnit> mdr;
    private static final String BUILD_ID_KEY = "eclipse.buildId";
    private static final String BUILD_ID_TAG = "@qualifier@";

    public ProductVersionPatcher(IProductDescriptor product, IActionContext context) {
        this.product = product;
        this.context = context;
    }

    public String getApplication() {
        return this.product.getApplication();
    }

    public List<BundleInfo> getBundleInfos() {
        List bis = this.product.getBundleInfos();
        if (bis.size() == 0) {
            return bis;
        }
        ArrayList<BundleInfo> pbis = new ArrayList<BundleInfo>(bis.size());
        for (BundleInfo bi : bis) {
            BundleInfo pbi = new BundleInfo(bi.getLocation(), bi.getStartLevel(), bi.isMarkedAsStarted());
            pbi.setBaseLocation(bi.getBaseLocation());
            pbi.setBundleId(bi.getBundleId());
            pbi.setManifest(bi.getManifest());
            pbi.setResolved(bi.isResolved());
            String id = bi.getSymbolicName();
            pbi.setSymbolicName(id);
            org.eclipse.equinox.p2.metadata.Version v = this.adjustVersion(id, bi.getVersion(), false);
            if (v != null) {
                pbi.setVersion(v.toString());
            }
            pbis.add(pbi);
        }
        return pbis;
    }

    public List<IVersionedId> getBundles(boolean includeFragments) {
        return this.adjustVersionedIdList(this.product.getBundles(includeFragments), false);
    }

    public String getConfigIniPath(String os) {
        return this.product.getConfigIniPath(os);
    }

    public Map<String, String> getConfigurationProperties() {
        String realBuildId;
        HashMap<String, String> cprops = this.product.getConfigurationProperties();
        String buildId = (String)cprops.get(BUILD_ID_KEY);
        if (buildId != null && buildId.contains(BUILD_ID_TAG) && (realBuildId = (String)this.context.getProperties().get("build.id")) != null) {
            cprops = new HashMap<String, String>(cprops);
            cprops.put(BUILD_ID_KEY, buildId.replace(BUILD_ID_TAG, realBuildId));
        }
        return cprops;
    }

    public List<IVersionedId> getFeatures() {
        return this.adjustVersionedIdList(this.product.getFeatures(), true);
    }

    public List<IVersionedId> getFragments() {
        return this.adjustVersionedIdList(this.product.getFragments(), false);
    }

    public String[] getIcons(String os) {
        return this.product.getIcons(os);
    }

    public String getId() {
        return this.product.getId();
    }

    public String getLauncherName() {
        return this.product.getLauncherName();
    }

    public String getLicenseText() {
        return this.product.getLicenseText();
    }

    public String getLicenseURL() {
        return this.product.getLicenseURL();
    }

    public File getLocation() {
        return this.product.getLocation();
    }

    public ProductContentType getProductContentType() {
        return this.product.getProductContentType();
    }

    public String getProductId() {
        return this.product.getProductId();
    }

    public String getProductName() {
        return this.product.getProductName();
    }

    public String getProgramArguments(String os) {
        return this.product.getProgramArguments(os);
    }

    public String getSplashLocation() {
        return this.product.getSplashLocation();
    }

    public String getVersion() {
        IVersionedId dep;
        List deps;
        String qualifier;
        org.eclipse.equinox.p2.metadata.Version version;
        String vstr = this.product.getVersion();
        org.eclipse.equinox.p2.metadata.Version version2 = version = vstr == null ? null : org.eclipse.equinox.p2.metadata.Version.parseVersion((String)vstr);
        if (org.eclipse.equinox.p2.metadata.Version.emptyVersion.equals(version)) {
            version = null;
        }
        if (!(version == null || (qualifier = VersionHelper.getQualifier((org.eclipse.equinox.p2.metadata.Version)version)) != null && qualifier.endsWith("qualifier"))) {
            return vstr;
        }
        boolean features = this.product.useFeatures();
        List list = deps = features ? this.product.getFeatures() : this.product.getBundles(false);
        if (deps.size() == 1 && (version = this.adjustVersion((dep = (IVersionedId)deps.get(0)).getId(), dep.getVersion(), features)) != null) {
            vstr = version.toString();
        }
        return vstr;
    }

    public String getVMArguments(String os) {
        return this.product.getVMArguments(os);
    }

    public boolean includeLaunchers() {
        return this.product.includeLaunchers();
    }

    public boolean useFeatures() {
        return this.product.useFeatures();
    }

    void setQueryable(IQueryable<IInstallableUnit> queryable) {
        this.mdr = queryable;
    }

    private org.eclipse.equinox.p2.metadata.Version adjustVersion(String id, String version, boolean feature) {
        return this.adjustVersion(id, version == null ? null : org.eclipse.equinox.p2.metadata.Version.parseVersion((String)version), feature);
    }

    private org.eclipse.equinox.p2.metadata.Version adjustVersion(String id, org.eclipse.equinox.p2.metadata.Version version, boolean isFeature) {
        IQuery query;
        IQueryResult result;
        VersionRange range = null;
        if (version != null && org.eclipse.equinox.p2.metadata.Version.emptyVersion.equals(version)) {
            version = null;
        }
        if (version != null) {
            String qualifier = VersionHelper.getQualifier((org.eclipse.equinox.p2.metadata.Version)version);
            if (qualifier == null || !qualifier.endsWith("qualifier")) {
                return version;
            }
            Version ov = new Version(version.toString());
            if (qualifier.length() > 9) {
                String lowQual = qualifier.substring(0, qualifier.length() - 1);
                String highQual = String.valueOf(lowQual) + "zzzzzzzzzzzzzzzz";
                org.eclipse.equinox.p2.metadata.Version low = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)ov.getMicro(), (String)lowQual);
                org.eclipse.equinox.p2.metadata.Version high = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)ov.getMicro(), (String)highQual);
                range = new VersionRange(low, true, high, true);
            } else {
                org.eclipse.equinox.p2.metadata.Version low = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)ov.getMicro());
                org.eclipse.equinox.p2.metadata.Version high = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)(ov.getMicro() + 1));
                range = new VersionRange(low, true, high, false);
            }
        }
        String iuID = id;
        if (isFeature && !iuID.endsWith(".feature.group")) {
            iuID = String.valueOf(iuID) + ".feature.group";
        }
        if ((result = this.mdr.query(query = QueryUtil.createIUQuery((String)iuID, range), null)).isEmpty()) {
            return version;
        }
        org.eclipse.equinox.p2.metadata.Version candidate = null;
        Iterator itor = result.iterator();
        while (itor.hasNext()) {
            org.eclipse.equinox.p2.metadata.Version v = ((IInstallableUnit)itor.next()).getVersion();
            if (candidate != null && v.compareTo((Object)candidate) <= 0) continue;
            candidate = v;
        }
        return candidate;
    }

    private List<IVersionedId> adjustVersionedIdList(List<IVersionedId> vns, boolean features) {
        int top = vns.size();
        if (top == 0) {
            return vns;
        }
        ArrayList<IVersionedId> pvns = new ArrayList<IVersionedId>(top);
        for (IVersionedId vn : vns) {
            String id = vn.getId();
            pvns.add((IVersionedId)new VersionedId(id, this.adjustVersion(id, vn.getVersion(), features)));
        }
        return pvns;
    }
}

