/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;

public class RemoveUnpackedSiblingsAction
implements IPublisherAction {
    private static IQuery<IArtifactKey> ANY_ARTIFACT = QueryUtil.createMatchQuery(IArtifactKey.class, (IExpression)ExpressionUtil.TRUE_EXPRESSION, (Object[])new Object[0]);

    private static boolean isPacked(IArtifactDescriptor desc) {
        return desc != null && "packed".equals(desc.getProperty("format")) && ProcessingStepHandler.canProcess((IArtifactDescriptor)desc);
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        final IArtifactRepository artifacts = info.getArtifactRepository();
        if (artifacts == null) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return Status.OK_STATUS;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        final ArrayList<IArtifactDescriptor> descsToRemove = new ArrayList<IArtifactDescriptor>();
        Iterator iter = artifacts.query(ANY_ARTIFACT, (IProgressMonitor)mon.newChild(1)).iterator();
        while (iter.hasNext()) {
            IArtifactDescriptor optimized = null;
            IArtifactDescriptor canonical = null;
            IArtifactDescriptor[] iArtifactDescriptorArray = artifacts.getArtifactDescriptors((IArtifactKey)iter.next());
            int n = iArtifactDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor desc = iArtifactDescriptorArray[n2];
                if (RemoveUnpackedSiblingsAction.isPacked(desc)) {
                    optimized = desc;
                } else {
                    canonical = desc;
                }
                ++n2;
            }
            if (optimized == null || canonical == null) continue;
            descsToRemove.add(canonical);
        }
        if (descsToRemove.size() > 0) {
            artifacts.executeBatch(new IRunnableWithProgress(){

                public void run(IProgressMonitor p) throws InvocationTargetException, OperationCanceledException {
                    SubMonitor sp = SubMonitor.convert((IProgressMonitor)p, (int)descsToRemove.size());
                    for (IArtifactDescriptor descToRemove : descsToRemove) {
                        artifacts.removeDescriptor(descToRemove, (IProgressMonitor)sp.newChild(1));
                    }
                }
            }, (IProgressMonitor)mon.newChild(1));
        }
        MonitorUtils.done((IProgressMonitor)monitor);
        return Status.OK_STATUS;
    }
}

