/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SaxableSite
extends AbstractSaxableElement
implements ISaxable {
    public static final String TAG = "site";
    public static final String ATTR_ASSOCIATE_SITES_URL = "associateSitesURL";
    public static final String ATTR_MIRRORS_URL = "mirrorsURL";
    private final SiteModel site;
    private final String mirrorsURL;
    private final String associateSitesURL;

    private static void addOptionalAttribute(AttributesImpl attrs, String name, String value) {
        if (value != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)name, (String)value);
        }
    }

    private static void writeArchives(ContentHandler handler, URLEntry[] archiveReferenceModels) throws SAXException {
        int top = archiveReferenceModels.length;
        int idx = 0;
        while (idx < top) {
            URLEntry sm = archiveReferenceModels[idx];
            AttributesImpl attrs = new AttributesImpl();
            Utils.addAttribute((AttributesImpl)attrs, (String)"path", (String)sm.getAnnotation());
            Utils.addAttribute((AttributesImpl)attrs, (String)"url", (String)sm.getURL());
            handler.startElement("", "", "archive", attrs);
            handler.endElement("", "", "archive");
            ++idx;
        }
    }

    private static void writeCategories(ContentHandler handler, SiteCategory[] categoryModels) throws SAXException {
        int top = categoryModels.length;
        int idx = 0;
        while (idx < top) {
            String label;
            SiteCategory cm = categoryModels[idx];
            AttributesImpl attrs = new AttributesImpl();
            String name = Trivial.trim((String)cm.getName());
            if (name != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"name", (String)name);
            }
            if ((label = Trivial.trim((String)cm.getLabel())) != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"label", (String)label);
            }
            handler.startElement("", "", "category-def", attrs);
            String desc = cm.getDescription();
            if (desc != null) {
                SaxableSite.writeDescription(handler, new URLEntry(null, desc));
            }
            handler.endElement("", "", "category-def");
            ++idx;
        }
    }

    private static void writeDescription(ContentHandler handler, URLEntry urlEntryModel) throws SAXException {
        String url = Trivial.trim((String)urlEntryModel.getURL());
        String text = Trivial.trim((String)urlEntryModel.getAnnotation());
        if (url != null || text != null) {
            Attributes attrs;
            if (url == null) {
                attrs = ISaxableElement.EMPTY_ATTRIBUTES;
            } else {
                attrs = new AttributesImpl();
                Utils.addAttribute((AttributesImpl)((AttributesImpl)attrs), (String)"url", (String)url);
            }
            handler.startElement("", "", "description", attrs);
            if (text != null) {
                handler.characters(text.toCharArray(), 0, text.length());
            }
            handler.endElement("", "", "description");
        }
    }

    private static void writeFeatures(ContentHandler handler, SiteFeature[] featureReferenceModels) throws SAXException {
        int top = featureReferenceModels.length;
        int idx = 0;
        while (idx < top) {
            SiteFeature sm = featureReferenceModels[idx];
            AttributesImpl attrs = new AttributesImpl();
            Utils.addAttribute((AttributesImpl)attrs, (String)"url", (String)sm.getURLString());
            Utils.addAttribute((AttributesImpl)attrs, (String)"id", (String)sm.getFeatureIdentifier());
            SaxableSite.addOptionalAttribute(attrs, "version", sm.getFeatureVersion());
            SaxableSite.addOptionalAttribute(attrs, "label", sm.getLabelNonLocalized());
            SaxableSite.addOptionalAttribute(attrs, "type", sm.getType());
            SaxableSite.addOptionalAttribute(attrs, "os", sm.getOS());
            SaxableSite.addOptionalAttribute(attrs, "ws", sm.getWS());
            SaxableSite.addOptionalAttribute(attrs, "nl", sm.getNL());
            SaxableSite.addOptionalAttribute(attrs, "arch", sm.getOSArch());
            SaxableSite.addOptionalAttribute(attrs, "patch", sm.getPatch());
            handler.startElement("", "", "feature", attrs);
            String[] categoryNames = sm.getCategoryNames();
            int cn = 0;
            while (cn < categoryNames.length) {
                AttributesImpl nameAttr = new AttributesImpl();
                Utils.addAttribute((AttributesImpl)nameAttr, (String)"name", (String)categoryNames[cn]);
                handler.startElement("", "", "category", nameAttr);
                handler.endElement("", "", "category");
                ++cn;
            }
            handler.endElement("", "", "feature");
            ++idx;
        }
    }

    public SaxableSite(SiteModel site) {
        this(site, null, null);
    }

    public SaxableSite(SiteModel site, String mirrorsURL, String associateSitesURL) {
        this.site = site;
        this.mirrorsURL = mirrorsURL;
        this.associateSitesURL = associateSitesURL;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public SiteModel getSite() {
        return this.site;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "", "", TAG);
        receiver.endDocument();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        String digestURL;
        String urlStr;
        String type = this.site.getType();
        if (type != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"type", (String)type);
        }
        if ((urlStr = this.site.getLocationURIString()) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"url", (String)urlStr);
        }
        if (this.mirrorsURL != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MIRRORS_URL, (String)this.mirrorsURL);
        }
        if (this.associateSitesURL != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ASSOCIATE_SITES_URL, (String)this.associateSitesURL);
        }
        if (this.site.isPack200Supported()) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"pack200", (String)"true");
        }
        if ((digestURL = Trivial.trim((String)this.site.getDigestURIString())) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"digestURL", (String)digestURL);
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        URLEntry description = this.site.getDescription();
        if (description != null) {
            SaxableSite.writeDescription(handler, description);
        }
        SaxableSite.writeFeatures(handler, this.site.getFeatures());
        SaxableSite.writeCategories(handler, this.site.getCategories());
        SaxableSite.writeArchives(handler, this.site.getArchives());
    }
}

