/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.equinox.internal.p2.updatesite.CategoryParser;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteReader
implements IStreamConsumer<SiteModel> {
    public static SiteModel getSite(File siteFile) throws CoreException, FileNotFoundException {
        SiteModel siteModel;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(siteFile));
            siteModel = SiteReader.parseSite(input, siteFile.toURI());
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        return siteModel;
    }

    public static SiteModel getSite(URL siteURL, IConnectContext cctx) throws CoreException, FileNotFoundException {
        InputStream input = null;
        try {
            input = DownloadManager.read((URL)siteURL, (IConnectContext)cctx);
            SiteModel siteModel = SiteReader.parseSite(input, URI.create(siteURL.toExternalForm()));
            return siteModel;
        }
        finally {
            IOUtils.close((Closeable)input);
        }
    }

    private static SiteModel parseSite(InputStream input, URI uri) throws CoreException, FileNotFoundException {
        try {
            CategoryParser siteParser = new CategoryParser(uri);
            SiteModel site = siteParser.parse(input);
            MultiStatus status = siteParser.getStatus();
            if (status != null) {
                throw BuckminsterException.wrap((IStatus)status);
            }
            return site;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (SAXException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public SiteModel consumeStream(IComponentReader fileReader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException, IOException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        monitor.beginTask(null, 1);
        try {
            monitor.subTask(Messages.Loading_site_definition);
            SiteModel site = SiteReader.parseSite(stream, URLUtils.normalizeToURI((String)streamName, (boolean)false));
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            SiteModel siteModel = site;
            return siteModel;
        }
        finally {
            monitor.done();
        }
    }
}

