/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;

public class SiteReferencesAction
extends AbstractPublisherAction {
    private final URLEntry[] urlEntries;

    public SiteReferencesAction(URLEntry[] urlEntries) {
        this.urlEntries = urlEntries;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        IMetadataRepository mdr = publisherInfo.getMetadataRepository();
        URLEntry[] uRLEntryArray = this.urlEntries;
        int n = this.urlEntries.length;
        int n2 = 0;
        while (n2 < n) {
            URLEntry refSite = uRLEntryArray[n2];
            this.generateSiteReference(refSite.getURL(), refSite.getAnnotation(), null, mdr);
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private void generateSiteReference(String location, String label, String featureId, IMetadataRepository metadataRepo) {
        if (metadataRepo == null) {
            return;
        }
        try {
            URI associateLocation = new URI(location);
            ArrayList<RepositoryReference> references = new ArrayList<RepositoryReference>(2);
            references.add(new RepositoryReference(associateLocation, label, 0, 1));
            references.add(new RepositoryReference(associateLocation, label, 1, 1));
            metadataRepo.addReferences(references);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

