/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.tasks.BundleConsolidator;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.p2.metadata.Version;

public class SourceBundleConsolidator
extends BundleConsolidator {
    private static final String LABEL_FORMAT = "{0} Source";

    public SourceBundleConsolidator(File inputFile, File outputFile, File propertiesFile, String qualifier) throws CoreException {
        super(inputFile, outputFile, propertiesFile, qualifier);
    }

    /*
     * Loose catch block
     */
    protected boolean treatManifest(Manifest manifest, String symbolicName, Version version) throws IOException {
        BMProperties translations;
        String vendor;
        String bundleName;
        String bundleManifestVersion;
        String manifestVersion;
        Attributes attributes;
        IActionContext ctx;
        block16: {
            if (symbolicName == null || version == null) {
                return false;
            }
            ctx = AbstractActor.getActiveContext();
            attributes = manifest.getMainAttributes();
            manifestVersion = Trivial.trim((String)attributes.getValue(Attributes.Name.MANIFEST_VERSION));
            bundleManifestVersion = Trivial.trim((String)attributes.getValue("Bundle-ManifestVersion"));
            bundleName = Trivial.trim((String)attributes.getValue("Bundle-Name"));
            vendor = Trivial.trim((String)attributes.getValue("Bundle-Vendor"));
            String bundleLocalization = attributes.getValue("Bundle-Localization");
            translations = Collections.emptyMap();
            BufferedInputStream inStream = null;
            try {
                IPath srcDir = ctx.getComponentLocation();
                IPath translationsFile = null;
                translationsFile = bundleLocalization == null ? srcDir.append("OSGI-INF/l10n/bundle.properties") : srcDir.append(String.valueOf(bundleLocalization) + ".properties");
                inStream = new BufferedInputStream(new FileInputStream(translationsFile.toFile()));
                translations = new BMProperties((InputStream)inStream);
            }
            catch (CoreException srcDir) {
                IOUtils.close(inStream);
                break block16;
            }
            catch (FileNotFoundException srcDir) {
                IOUtils.close(inStream);
                break block16;
                catch (Throwable throwable) {
                    IOUtils.close(inStream);
                    throw throwable;
                }
            }
            IOUtils.close((Closeable)inStream);
        }
        if (bundleName != null) {
            String format;
            if (bundleName.charAt(0) == '%' && (bundleName = (String)translations.get(bundleName.substring(1))) == null) {
                bundleName = symbolicName;
            }
            if ((format = (String)ctx.getProperties().get(IPDEConstants.PROP_PDE_SOURCE_BUNDLE_LABEL_FORMAT)) == null) {
                format = LABEL_FORMAT;
            }
            bundleName = MessageFormat.format(format, bundleName);
        }
        if (vendor != null && vendor.charAt(0) == '%') {
            vendor = (String)translations.get(vendor.substring(1));
        }
        manifest.clear();
        String src = (String)this.getProperties().get("src.additionalRoots");
        if (src == null) {
            src = ".";
        }
        String versionStr = version.toString();
        attributes.putValue("Bundle-SymbolicName", String.valueOf(symbolicName) + ".source");
        attributes.putValue("Eclipse-SourceBundle", String.valueOf(symbolicName) + ";version=\"" + versionStr + "\";roots=\"" + src + "\"");
        attributes.putValue("Bundle-Version", versionStr);
        if (manifestVersion != null) {
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), manifestVersion);
        }
        if (bundleManifestVersion != null) {
            attributes.putValue("Bundle-ManifestVersion", bundleManifestVersion);
        }
        if (bundleName != null) {
            attributes.putValue("Bundle-Name", bundleName);
        }
        if (vendor != null) {
            attributes.putValue("Bundle-Vendor", vendor);
        }
        return true;
    }
}

