/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.pde.internal.model.EditableFeatureModel;
import org.eclipse.buckminster.pde.internal.model.ExternalBundleModel;
import org.eclipse.buckminster.pde.tasks.GroupConsolidator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFeatureCreator
implements IPDEConstants,
IBuildPropertiesConstants {
    private static final String FEATURE_SUFFIX = ".feature";
    private static final String SOURCE_SUFFIX = ".source";
    private static final String DESCRIPTION_FORMAT = "Generated source feature. The original description is:\n\n{0}";
    private static final String LABEL_FORMAT = "Source for {0}";
    private final File inputFile;
    private final File outputFile;
    private final List<File> translationFiles;
    private final List<File> featuresAndBundles;
    private Map<String, String> translations;
    private Map<String, String> usedTranslations;

    public static String createSourceFeatureId(String originalId) {
        StringBuilder sourceIdBld = new StringBuilder();
        if (originalId.endsWith(FEATURE_SUFFIX)) {
            sourceIdBld.append(originalId, 0, originalId.length() - FEATURE_SUFFIX.length());
            sourceIdBld.append(SOURCE_SUFFIX);
            sourceIdBld.append(FEATURE_SUFFIX);
        } else {
            sourceIdBld.append(originalId);
            sourceIdBld.append(SOURCE_SUFFIX);
        }
        return sourceIdBld.toString();
    }

    public SourceFeatureCreator(File inputFile, List<File> translationFiles, File outputFile, List<File> featuresAndBundles) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.featuresAndBundles = featuresAndBundles;
        this.translationFiles = translationFiles;
    }

    public void run() throws CoreException, FileNotFoundException {
        IFeatureInfo description;
        IFeatureInfo license;
        IFeature originalFeature = FeatureModelReader.readEditableFeatureModel(this.inputFile).getFeature();
        EditableFeatureModel featureModel = new EditableFeatureModel(this.outputFile);
        featureModel.setDirty(true);
        IFeature sourceFeature = featureModel.getFeature();
        IActionContext ctx = AbstractActor.getActiveContext();
        String originalId = originalFeature.getId();
        String sourceId = SourceFeatureCreator.createSourceFeatureId(originalId);
        sourceFeature.setId(sourceId);
        sourceFeature.setVersion(originalFeature.getVersion());
        String label = originalFeature.getLabel();
        Map props = ctx.getProperties();
        String format = (String)props.get(IPDEConstants.PROP_PDE_SOURCE_FEATURE_LABEL_FORMAT);
        if (format == null) {
            format = LABEL_FORMAT;
        }
        if (!this.addLocalizedProperty(ctx, label, format)) {
            label = MessageFormat.format(format, label);
        }
        sourceFeature.setLabel(label);
        sourceFeature.setOS(originalFeature.getOS());
        sourceFeature.setArch(originalFeature.getArch());
        sourceFeature.setWS(originalFeature.getWS());
        sourceFeature.setNL(originalFeature.getNL());
        String providerName = originalFeature.getProviderName();
        this.addLocalizedProperty(ctx, providerName, null);
        sourceFeature.setProviderName(providerName);
        sourceFeature.setURL(originalFeature.getURL());
        IFeatureInfo copyright = originalFeature.getFeatureInfo(1);
        if (copyright != null) {
            this.cloneInfo(ctx, sourceFeature, copyright, null);
        }
        if ((license = originalFeature.getFeatureInfo(2)) != null) {
            this.cloneInfo(ctx, sourceFeature, license, null);
        }
        if ((description = originalFeature.getFeatureInfo(0)) != null) {
            format = (String)props.get(IPDEConstants.PROP_PDE_SOURCE_FEATURE_DESCRIPTION_FORMAT);
            if (format == null) {
                format = DESCRIPTION_FORMAT;
            }
            this.cloneInfo(ctx, sourceFeature, description, format);
        }
        for (File featureOrBundle : this.featuresAndBundles) {
            Object model2;
            InputStream input = null;
            try {
                input = GroupConsolidator.getInput(featureOrBundle, "feature.xml");
                model2 = FeatureModelReader.readFeatureModel(input);
                IFeature feature = model2.getFeature();
                FeatureChild fc = new FeatureChild();
                fc.setModel((IFeatureModel)featureModel);
                fc.loadFrom(model2.getFeature());
                fc.setArch(feature.getArch());
                fc.setOS(feature.getOS());
                fc.setWS(feature.getWS());
                fc.setNL(feature.getNL());
                fc.setLabel(feature.getLabel());
                fc.setVersion(feature.getVersion());
                sourceFeature.addIncludedFeatures(new IFeatureChild[]{fc});
                continue;
            }
            catch (FileNotFoundException model2) {
            }
            finally {
                IOUtils.close((Closeable)input);
                input = null;
            }
            try {
                input = GroupConsolidator.getInput(featureOrBundle, "META-INF/MANIFEST.MF");
                model2 = new ExternalBundleModel(featureOrBundle);
                model2.load(input, true);
                BundleFragmentModel bmodel = model2.isFragmentModel() ? new BundleFragmentModel() : new BundlePluginModel();
                bmodel.setEnabled(true);
                bmodel.setBundleModel((IBundleModel)model2);
                IPluginBase plugin = bmodel.getPluginBase();
                if (plugin.getId() == null) {
                    throw BuckminsterException.fromMessage((String)"Unable to extract feature.xml or a valid OSGi bundle manifest from %s", (Object[])new Object[]{featureOrBundle.getAbsolutePath()});
                }
                FeaturePlugin fp = new FeaturePlugin();
                fp.loadFrom(plugin);
                fp.setModel((IFeatureModel)featureModel);
                fp.setUnpack(false);
                fp.setVersion(plugin.getVersion());
                String ver = plugin.getVersion();
                String id = plugin.getId();
                if (id.endsWith(SOURCE_SUFFIX)) {
                    String origId = id.substring(0, id.length() - SOURCE_SUFFIX.length());
                    IFeaturePlugin[] iFeaturePluginArray = originalFeature.getPlugins();
                    int n = iFeaturePluginArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFeaturePlugin originalPlugin = iFeaturePluginArray[n2];
                        if (originalPlugin.getId().equals(origId) && originalPlugin.getVersion().equals(ver)) {
                            fp.setArch(originalPlugin.getArch());
                            fp.setOS(originalPlugin.getOS());
                            fp.setWS(originalPlugin.getWS());
                            fp.setNL(originalPlugin.getNL());
                            break;
                        }
                        ++n2;
                    }
                }
                sourceFeature.addPlugins(new IFeaturePlugin[]{fp});
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                IOUtils.close((Closeable)input);
            }
        }
        featureModel.save();
        this.saveTranslations();
    }

    private boolean addLocalizedProperty(IActionContext ctx, String key, String format) throws CoreException {
        String mapKey;
        String translated;
        if (key == null || !key.startsWith("%")) {
            return false;
        }
        if (this.translations == null) {
            for (File translationFile : this.translationFiles) {
                if (!"feature.properties".equals(translationFile.getName())) continue;
                BufferedInputStream inStream = null;
                try {
                    try {
                        inStream = new BufferedInputStream(new FileInputStream(translationFile));
                        this.translations = new BMProperties((InputStream)inStream);
                    }
                    catch (IOException iOException) {
                        IOUtils.close(inStream);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(inStream);
                    throw throwable;
                }
                IOUtils.close((Closeable)inStream);
                break;
            }
            if (this.translations == null) {
                this.translations = Collections.emptyMap();
            }
        }
        if ((translated = this.translations.get(mapKey = key.substring(1))) == null) {
            PDEPlugin.getLogger().warning("Unable to find translation for property %s", new Object[]{key});
            return false;
        }
        if (format != null) {
            translated = MessageFormat.format(format, translated);
        }
        if (this.usedTranslations == null) {
            this.usedTranslations = new HashMap<String, String>();
        }
        this.usedTranslations.put(mapKey, translated);
        return true;
    }

    private void cloneInfo(IActionContext ctx, IFeature newOwner, IFeatureInfo original, String descriptionFormat) throws CoreException {
        IFeatureInfo copy = newOwner.getModel().getFactory().createInfo(original.getIndex());
        String description = original.getDescription();
        if (!this.addLocalizedProperty(ctx, description, descriptionFormat) && descriptionFormat != null) {
            description = MessageFormat.format(descriptionFormat, description);
        }
        copy.setDescription(description);
        this.addLocalizedProperty(ctx, original.getLabel(), null);
        copy.setLabel(original.getLabel());
        this.addLocalizedProperty(ctx, original.getURL(), null);
        copy.setURL(original.getURL());
        newOwner.setFeatureInfo(copy, original.getIndex());
    }

    private void saveTranslations() throws CoreException {
        if (this.usedTranslations != null) {
            BufferedOutputStream out = null;
            try {
                try {
                    out = new BufferedOutputStream(new FileOutputStream(new File(this.outputFile.getParentFile(), "feature.properties")));
                    BMProperties.store(this.usedTranslations, (OutputStream)out, null);
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(out);
                throw throwable;
            }
            IOUtils.close((Closeable)out);
        }
    }
}

