/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.buckminster.ui.editor.ExternalFileEditorInput;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SaveRunnable
implements IRunnableWithProgress {
    private final ISaxable saxable;
    private final IPath location;
    private IEditorInput newInput;

    public SaveRunnable(ISaxable saxable, IPath location) {
        this.saxable = saxable;
        this.location = location;
    }

    public IEditorInput getSavedInput() {
        return this.newInput;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IContainer container;
            if (this.location.segmentCount() > 1 && (container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(this.location.removeLastSegments(1))) != null) {
                InputStream stream = null;
                try {
                    IFile file = container.getFile((IPath)new Path(this.location.lastSegment()));
                    stream = Utils.getInputStream((ISaxable)this.saxable);
                    if (file.exists()) {
                        file.setContents(stream, 2, monitor);
                    } else {
                        file.create(stream, false, monitor);
                    }
                    this.newInput = new FileEditorInput(file);
                }
                catch (Throwable throwable) {
                    IOUtils.close(stream);
                    throw throwable;
                }
                IOUtils.close((Closeable)stream);
                return;
            }
            FileOutputStream stream = null;
            try {
                File file = this.location.toFile();
                stream = new FileOutputStream(file);
                Utils.serialize((ISaxable)this.saxable, (OutputStream)stream);
                this.newInput = new ExternalFileEditorInput(file);
            }
            catch (Throwable throwable) {
                IOUtils.close(stream);
                throw throwable;
            }
            IOUtils.close((Closeable)stream);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

