/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dialogs;

import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FileExtensionFilter
extends ViewerFilter {
    private String extension;

    public FileExtensionFilter(String extension) {
        this.extension = extension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            return ((IFile)element).getName().toLowerCase(Locale.ENGLISH).endsWith(this.extension);
        }
        if (!(element instanceof IContainer)) {
            return false;
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return false;
        }
        try {
            IResource[] resources = ((IContainer)element).members();
            int i = 0;
            while (true) {
                if (i >= resources.length) {
                    return false;
                }
                if (this.select(viewer, parent, resources[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }
}

