/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.List;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.structured.StructuredTable;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributesTable<T extends TopLevelAttributeBuilder>
extends StructuredTable<T> {
    private static final String ERROR_MESSAGE_EMPTY_NAME = Messages.name_cannnot_be_empty;
    private CSpecEditor editor;
    private CSpecBuilder cspec;
    private Text nameText;
    private Button publicCheck;
    private Text documentationText;
    private T currentBuilder;

    public AttributesTable(CSpecEditor editor, List<T> data, CSpecBuilder cspec, boolean readOnly) {
        super(data, readOnly);
        this.editor = editor;
        this.cspec = cspec;
    }

    @Override
    public void enableFields(boolean enabled) {
        this.nameText.setEnabled(enabled);
        this.publicCheck.setEnabled(enabled);
        this.documentationText.setEnabled(enabled);
    }

    public CSpecEditor getCSpecEditor() {
        return this.editor;
    }

    public T getCurrentBuilder() {
        return this.currentBuilder;
    }

    @Override
    public String[] getTableViewerColumnHeaders() {
        return new String[]{Messages.name, Messages.public_label};
    }

    @Override
    public int[] getTableViewerColumnWeights() {
        return new int[]{80, 20};
    }

    @Override
    public Object getTableViewerField(T builder, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return builder.getName();
            }
            case 1: {
                return builder.isPublic();
            }
        }
        return null;
    }

    protected Control createDocumentationStackLayer(Composite stackComposite) {
        Composite docComposite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        docComposite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(docComposite, Messages.documentation, 1);
        this.documentationText = UiUtils.createGridText(docComposite, 1, 0, this.isReadOnly(), 2);
        this.documentationText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.documentationText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        docComposite.setData("focusControl", (Object)this.documentationText);
        return docComposite;
    }

    protected CSpecBuilder getCSpecBuilder() {
        return this.cspec;
    }

    protected Text getNameText() {
        return this.nameText;
    }

    @Override
    protected void refreshRow(T builder) {
        this.currentBuilder = builder;
        this.nameText.setText(TextUtils.notNullString((Object)builder.getName()));
        this.publicCheck.setSelection(builder.isPublic());
        Documentation doc = builder.getDocumentation();
        this.documentationText.setText(TextUtils.notNullString((Object)(doc == null ? null : doc.toString())));
    }

    protected void setNameText(Text nameText) {
        this.nameText = nameText;
        nameText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
    }

    protected void setPublicCheck(Button publicCheck) {
        this.publicCheck = publicCheck;
        publicCheck.addSelectionListener((SelectionListener)this.FIELD_LISTENER);
    }

    @Override
    protected void setRowValues(T builder) throws ValidatorException {
        if (UiUtils.trimmedValue(this.nameText) == null) {
            throw new ValidatorException(ERROR_MESSAGE_EMPTY_NAME);
        }
        builder.setName(UiUtils.trimmedValue(this.nameText));
        builder.setPublic(this.publicCheck.getSelection());
        String doc = UiUtils.trimmedValue(this.documentationText);
        try {
            builder.setDocumentation(doc == null ? null : Documentation.parse((String)doc));
        }
        catch (Exception e) {
            throw new ValidatorException(e.getMessage());
        }
    }
}

