/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.AttributesTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.GroupPrerequisitesTable;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTableEditor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsTable
extends AttributesTable<GroupBuilder> {
    private Text rebasePathText;
    private List<PrerequisiteBuilder> prerequisites = new ArrayList<PrerequisiteBuilder>();
    private SimpleTableEditor<PrerequisiteBuilder> prerequisitesEditor;

    public GroupsTable(CSpecEditor editor, List<GroupBuilder> data, CSpecBuilder cspec, boolean readOnly) {
        super(editor, data, cspec, readOnly);
    }

    @Override
    public void enableFields(boolean enabled) {
        super.enableFields(enabled);
        this.rebasePathText.setEnabled(enabled);
        this.prerequisitesEditor.setEnabled(enabled);
    }

    @Override
    public void fillStack(Composite stackComposite) {
        this.addStackMapping(Messages.general, this.createGeneralStackLayer(stackComposite));
        this.addStackMapping(Messages.documentation, this.createDocumentationStackLayer(stackComposite));
    }

    @Override
    protected GroupBuilder createNewRow() {
        return this.getCSpecBuilder().createGroupBuilder();
    }

    @Override
    protected void refreshRow(GroupBuilder builder) {
        super.refreshRow(builder);
        IPath rebasePath = builder.getPrerequisiteRebase();
        this.rebasePathText.setText(TextUtils.notNullString((Object)(rebasePath == null ? null : rebasePath.toOSString())));
        CSpecEditorUtils.copyAndSortItems(builder.getPrerequisites(), this.prerequisites, CSpecEditorUtils.getPrerequisiteComparator());
        this.prerequisitesEditor.refresh();
    }

    @Override
    protected void setRowValues(GroupBuilder builder) throws ValidatorException {
        super.setRowValues(builder);
        String rebasePathString = UiUtils.trimmedValue(this.rebasePathText);
        IPath rebasePath = null;
        if (rebasePathString != null) {
            rebasePath = Path.fromOSString((String)rebasePathString);
        }
        builder.setPrerequisiteRebase(rebasePath);
        List prereqs = builder.getPrerequisites();
        if (prereqs != null) {
            prereqs.clear();
        }
        for (PrerequisiteBuilder prerequisite : this.prerequisites) {
            PrerequisiteBuilder newPrerequisite = builder.createPrerequisiteBuilder();
            newPrerequisite.initFrom((IPrerequisite)prerequisite.createPrerequisite());
            try {
                builder.addPrerequisite(newPrerequisite);
            }
            catch (PrerequisiteAlreadyDefinedException e) {
                throw new ValidatorException(e.getMessage());
            }
        }
    }

    private Control createGeneralStackLayer(Composite stackComposite) {
        Composite geComposite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        geComposite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(geComposite, Messages.general, 2);
        UiUtils.createGridLabel(geComposite, Messages.name_with_colon, 1, 0, 0);
        this.setNameText(UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0));
        UiUtils.createGridLabel(geComposite, Messages.public_with_colon, 1, 0, 0);
        this.setPublicCheck(UiUtils.createCheckButton(geComposite, null, this.isReadOnly(), null));
        UiUtils.createGridLabel(geComposite, Messages.release_path_with_colon, 1, 0, 0);
        this.rebasePathText = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.rebasePathText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createEmptyLabel(geComposite);
        UiUtils.createEmptyLabel(geComposite);
        Label label = UiUtils.createGridLabel(geComposite, Messages.prerequisites_with_colon, 1, 0, 0);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        GroupPrerequisitesTable preTable = new GroupPrerequisitesTable(this.getCSpecEditor(), this, this.prerequisites, (TopLevelAttributeBuilder)this.createNewRow(), this.isReadOnly());
        preTable.addTableModifyListener(this.FIELD_LISTENER);
        this.prerequisitesEditor = new SimpleTableEditor<PrerequisiteBuilder>(geComposite, preTable, null, Messages.group_prerequisite_with_dash, null, null, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.prerequisitesEditor.setLayoutData(gridData);
        geComposite.setData("focusControl", (Object)this.getNameText());
        return geComposite;
    }
}

