/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.prefs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.prefedit.IPreferenceDescriptor;
import org.eclipse.buckminster.core.prefedit.IPreferenceValidator;
import org.eclipse.buckminster.core.resolver.IResolverFactory;
import org.eclipse.buckminster.core.resolver.ResolverFactoryMaintainer;
import org.eclipse.buckminster.runtime.IBuckminsterPreferenceConstants;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.prefs.EnumFieldEditor;
import org.eclipse.buckminster.ui.prefs.LogLevel;
import org.eclipse.buckminster.ui.prefs.NestedFieldEditor;
import org.eclipse.buckminster.ui.prefs.PasswordFieldEditor;
import org.eclipse.buckminster.ui.prefs.ResolutionResolverListEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DynamicPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IBuckminsterPreferenceConstants {
    private static IPreferenceValidator nullValidator = new IPreferenceValidator(){

        public boolean validate(String value) {
            return true;
        }
    };
    private Composite resolversParent;
    private StackLayout resolversStack;

    public DynamicPreferencePage() {
        super(1);
        this.setDescription(Messages.buckminster_preferences);
        this.setPreferenceStore(UiPlugin.getDefault().getBuckminsterPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value")) {
            if (event.getSource() instanceof ResolutionResolverListEditor) {
                this.selectResolverPropertyPane(event.getNewValue());
            }
        } else {
            super.propertyChange(event);
        }
    }

    protected void addDynamicFieldEditors(Composite parent, String nodeName, IPreferenceDescriptor[] descriptors) {
        final IPreferenceStore nodePrefs = UiPlugin.getDefault().getBuckminsterPreferenceStore(nodeName);
        IPreferenceDescriptor[] iPreferenceDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            Object editor;
            IPreferenceDescriptor descriptor = iPreferenceDescriptorArray[n2];
            String name = descriptor.getName();
            String label = descriptor.getLabel();
            IPreferenceValidator descValidator = descriptor.getValidator();
            if (descValidator == null) {
                descValidator = nullValidator;
            }
            final IPreferenceValidator validator = descValidator;
            switch (descriptor.getType()) {
                case Boolean: {
                    editor = new BooleanFieldEditor(name, label, parent){

                        public IPreferenceStore getPreferenceStore() {
                            return nodePrefs;
                        }
                    };
                    break;
                }
                case Directory: {
                    editor = new DirectoryFieldEditor(name, label, parent){

                        public IPreferenceStore getPreferenceStore() {
                            return nodePrefs;
                        }

                        protected boolean checkState() {
                            return super.checkState() && validator.validate(UiUtils.trimmedValue(this.getTextControl()));
                        }
                    };
                    break;
                }
                case Enum: {
                    Enum[] enums = descriptor.getEnums();
                    int idx = enums.length;
                    String[][] labelsAndValues = new String[idx][2];
                    while (--idx >= 0) {
                        labelsAndValues[idx][0] = enums[idx].toString();
                        labelsAndValues[idx][1] = enums[idx].name();
                    }
                    editor = new RadioGroupFieldEditor(name, label, 1, labelsAndValues, parent){

                        public IPreferenceStore getPreferenceStore() {
                            return nodePrefs;
                        }
                    };
                    break;
                }
                case File: {
                    editor = new FileFieldEditor(name, label, parent){

                        public IPreferenceStore getPreferenceStore() {
                            return nodePrefs;
                        }

                        protected boolean checkState() {
                            return super.checkState() && validator.validate(UiUtils.trimmedValue(this.getTextControl()));
                        }
                    };
                    break;
                }
                case Integer: {
                    editor = new IntegerFieldEditor(name, label, parent, descriptor.getTextWidth()){

                        public IPreferenceStore getPreferenceStore() {
                            return nodePrefs;
                        }

                        protected boolean checkState() {
                            return super.checkState() && validator.validate(UiUtils.trimmedValue(this.getTextControl()));
                        }
                    };
                    int[] range = descriptor.getIntegerRange();
                    if (range == null) break;
                    ((IntegerFieldEditor)editor).setValidRange(range[0], range[1]);
                    break;
                }
                case Path: {
                    editor = new PathEditor(name, label, label, parent){

                        public IPreferenceStore getPreferenceStore() {
                            return nodePrefs;
                        }
                    };
                    break;
                }
                case Password: {
                    editor = new PasswordFieldEditor(name, label, descriptor.getTextWidth(), parent, nodeName){

                        public IPreferenceStore getPreferenceStore() {
                            return nodePrefs;
                        }

                        protected boolean checkState() {
                            return validator.validate(UiUtils.trimmedValue(this.getTextControl()));
                        }
                    };
                    break;
                }
                default: {
                    editor = new StringFieldEditor(name, label, descriptor.getTextWidth(), parent){

                        public IPreferenceStore getPreferenceStore() {
                            return nodePrefs;
                        }

                        protected boolean checkState() {
                            return validator.validate(UiUtils.trimmedValue(this.getTextControl()));
                        }
                    };
                }
            }
            this.addField((FieldEditor)editor);
            ++n2;
        }
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new StringFieldEditor("siteName", Messages.site_name, this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor("bmProjectContents", Messages.buckminster_project_folder, this.getFieldEditorParent()));
        this.addField(new EnumFieldEditor("logLevelConsole", Messages.console_logger_level_with_colon, LogLevel.values(), this.getFieldEditorParent()));
        this.addField(new EnumFieldEditor("logLevelEclipseLogger", Messages.eclipse_logger_level_with_colon, LogLevel.values(), this.getFieldEditorParent()));
        this.addField(new EnumFieldEditor("logLevelAntLogger", Messages.ant_logger_level_with_colon, LogLevel.values(), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("logEclipseToConsole", Messages.copy_eclipse_log_events_to_console, this.getFieldEditorParent()));
        IntegerFieldEditor intEditor = new IntegerFieldEditor("maxParallelMaterializationJobs", Messages.max_number_of_parallel_materializations, this.getFieldEditorParent());
        intEditor.setValidRange(1, 12);
        this.addField((FieldEditor)intEditor);
        intEditor = new IntegerFieldEditor("connectionRetryCount", Messages.connection_retry_count, this.getFieldEditorParent());
        intEditor.setValidRange(0, 5);
        this.addField((FieldEditor)intEditor);
        intEditor = new IntegerFieldEditor("connectionRetryDelay", Messages.connection_retry_delay_in_seconds, this.getFieldEditorParent());
        intEditor.setValidRange(0, 60);
        this.addField((FieldEditor)intEditor);
        this.addField(new ResolutionResolverListEditor("queryResolverSortOrder", Messages.resolver_order, this.getFieldEditorParent()));
        IResolverFactory[] factories = ResolverFactoryMaintainer.getInstance().getResolverFactories();
        int top = factories.length;
        if (top == 1) {
            IResolverFactory factory = factories[0];
            factory.initDefaultPreferences();
            NestedFieldEditor nfe = new NestedFieldEditor(factory.getId(), this.getFieldEditorParent());
            this.addDynamicFieldEditors(nfe.getControl(), factory.getId(), factory.getPreferenceDescriptors());
            this.addField(nfe);
        } else if (top > 1) {
            NestedFieldEditor resolvers = new NestedFieldEditor("", this.getFieldEditorParent());
            this.addField(resolvers);
            this.resolversParent = resolvers.getControl();
            int idx = 0;
            while (idx < top) {
                IResolverFactory factory = factories[idx];
                factory.initDefaultPreferences();
                String factoryId = factory.getId();
                NestedFieldEditor nfe = new NestedFieldEditor(factoryId, this.resolversParent);
                Composite nfeComp = nfe.getControl();
                nfeComp.setData((Object)factoryId);
                this.addDynamicFieldEditors(nfeComp, factoryId, factory.getPreferenceDescriptors());
                this.addField(nfe);
                ++idx;
            }
            this.resolversStack = new StackLayout();
            this.resolversParent.setLayout((Layout)this.resolversStack);
            this.resolversParent.setVisible(false);
        }
        Group tsGroup = new Group(this.getFieldEditorParent(), 0);
        tsGroup.setLayout((Layout)new GridLayout(2, false));
        tsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        tsGroup.setText(Messages.troubleshooting);
        UiUtils.createPushButton((Composite)tsGroup, Messages.clear_url_cache, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CorePlugin plugin = CorePlugin.getDefault();
                plugin.clearRemoteFileCache();
                plugin.clearURLCache();
            }
        });
        UiUtils.createPushButton((Composite)tsGroup, Messages.refresh_meta_data, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow wbWin = workbench.getActiveWorkbenchWindow();
                if (wbWin == null) {
                    WorkspaceInfo.forceRefreshOnAll((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                try {
                    wbWin.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                WorkspaceInfo.forceRefreshOnAll((IProgressMonitor)monitor);
                            }
                            catch (OperationCanceledException e) {
                                throw new InterruptedException();
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    CorePlugin.getLogger().error((Throwable)e, e.toString(), new Object[0]);
                }
            }
        });
    }

    void selectResolverPropertyPane(Object factoryId) {
        if (this.resolversParent == null) {
            return;
        }
        Control[] children = this.resolversParent.getChildren();
        int idx = children.length;
        while (--idx >= 0) {
            Control child = children[idx];
            if (!Trivial.equalsAllowNull((Object)child.getData(), (Object)factoryId)) continue;
            this.resolversStack.topControl = child;
            break;
        }
        boolean visible = idx >= 0;
        this.resolversParent.setVisible(visible);
        if (visible) {
            this.resolversParent.layout();
        }
    }
}

