/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.prefs;

import java.util.ArrayList;
import org.eclipse.buckminster.core.resolver.ResolverFactoryMaintainer;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ResolutionResolverListEditor
extends FieldEditor {
    private String value;
    private Button addButton;
    private Button moveDownButton;
    private Button moveUpButton;
    private ListViewer queryResolvers;
    private ListViewer queryResolversToAdd;
    private String[] registeredResolverFactories;
    private Button removeButton;
    private Group resolveOrderGroup;

    public ResolutionResolverListEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    public Control getControl(Composite parent, int numColumns) {
        if (this.resolveOrderGroup == null) {
            this.resolveOrderGroup = new Group(parent, 0);
            this.resolveOrderGroup.setLayout((Layout)new GridLayout(3, false));
            this.resolveOrderGroup.setLayoutData((Object)new GridData(4, 4, true, true, numColumns, 1));
            this.resolveOrderGroup.setText(Messages.order_of_resolution);
            this.queryResolvers = new ListViewer((Composite)this.resolveOrderGroup, 2048);
            this.queryResolvers.getList().setLayoutData((Object)new GridData(4, 4, true, true));
            this.queryResolvers.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.queryResolvers.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.queryResolvers.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ResolutionResolverListEditor.this.enableDisableUpDownButtons(true);
                }
            });
            Composite buttonBox = new Composite((Composite)this.resolveOrderGroup, 0);
            buttonBox.setLayout((Layout)new GridLayout(1, true));
            buttonBox.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            this.addButton = UiUtils.createPushButton(buttonBox, Messages.add_with_arrow_left, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResolutionResolverListEditor.this.addResolver();
                }
            });
            this.addButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.removeButton = UiUtils.createPushButton(buttonBox, Messages.remove_with_arrow_right, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResolutionResolverListEditor.this.removeResolver();
                }
            });
            this.removeButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.moveUpButton = UiUtils.createPushButton(buttonBox, Messages.move_up, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResolutionResolverListEditor.this.swapAndReselect(0, -1);
                }
            });
            this.moveUpButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.moveDownButton = UiUtils.createPushButton(buttonBox, Messages.move_down, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResolutionResolverListEditor.this.swapAndReselect(1, 0);
                }
            });
            this.moveDownButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.queryResolversToAdd = new ListViewer((Composite)this.resolveOrderGroup, 2048);
            this.queryResolversToAdd.getList().setLayoutData((Object)new GridData(4, 4, true, true));
            this.queryResolversToAdd.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.queryResolversToAdd.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.queryResolversToAdd.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ResolutionResolverListEditor.this.enableDisableUpDownButtons(false);
                }
            });
        }
        return this.resolveOrderGroup;
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.resolveOrderGroup.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getControl(parent, numColumns);
    }

    protected void doLoad() {
        this.loadLists(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        ResolverFactoryMaintainer.getInstance().setDefaultResolutionOrder();
        this.loadLists(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doStore() {
        String v = BuckminsterPreferences.createQueryResolverSortOrder((String[])(this.queryResolvers == null ? this.getRegisteredResolverFactories() : this.queryResolvers.getList().getItems()));
        IPreferenceStore store = this.getPreferenceStore();
        String prefName = this.getPreferenceName();
        if (v == null) {
            store.setToDefault(prefName);
            BuckminsterPreferences.setCustomQueryResolverSortOrder((boolean)false);
        } else {
            if (v.equals(store.getString(prefName))) {
                return;
            }
            store.setValue(prefName, v);
            BuckminsterPreferences.setCustomQueryResolverSortOrder((boolean)true);
        }
    }

    void addResolver() {
        this.moveItem(this.queryResolversToAdd, this.queryResolvers);
    }

    void enableDisableUpDownButtons(boolean fromResolvers) {
        List addList;
        String oldValue = this.value;
        List list = this.queryResolvers.getList();
        int top = list.getItemCount();
        int idx = list.getSelectionIndex();
        if (fromResolvers) {
            String string = this.value = idx >= 0 ? list.getItem(idx) : null;
            if (!Trivial.equalsAllowNull((Object)oldValue, (Object)this.value)) {
                this.fireValueChanged("field_editor_value", oldValue, this.value);
            }
        }
        this.addButton.setEnabled((addList = this.queryResolversToAdd.getList()).getItemCount() > 0 && addList.getSelectionIndex() >= 0);
        this.moveUpButton.setEnabled(idx > 0);
        this.removeButton.setEnabled(idx >= 0);
        this.moveDownButton.setEnabled(idx >= 0 && idx < top - 1);
    }

    void removeResolver() {
        this.moveItem(this.queryResolvers, this.queryResolversToAdd);
    }

    void swapAndReselect(int idxOffset, int selectionOffset) {
        List list = this.queryResolvers.getList();
        int idx = list.getSelectionIndex() + idxOffset;
        if (idx <= 0) {
            return;
        }
        String[] items = list.getItems();
        if (idx >= items.length) {
            return;
        }
        String moved = items[idx - 1];
        items[idx - 1] = items[idx];
        items[idx] = moved;
        list.setItems(items);
        list.select(idx + selectionOffset);
        this.enableDisableUpDownButtons(true);
    }

    private String[] getPossibleResolverAdditions() {
        String[] registered = this.getRegisteredResolverFactories();
        String[] current = this.queryResolvers.getList().getItems();
        ArrayList<String> possible = null;
        String[] stringArray = registered;
        int n = registered.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            boolean found = false;
            String[] stringArray2 = current;
            int n3 = current.length;
            int n4 = 0;
            while (n4 < n3) {
                String currName = stringArray2[n4];
                if (currName.equals(name)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                if (possible == null) {
                    possible = new ArrayList<String>();
                }
                possible.add(name);
            }
            ++n2;
        }
        return possible == null ? Trivial.EMPTY_STRING_ARRAY : possible.toArray(new String[possible.size()]);
    }

    private synchronized String[] getRegisteredResolverFactories() {
        if (this.registeredResolverFactories == null) {
            this.registeredResolverFactories = ResolverFactoryMaintainer.getRegisterFactoryIDs();
        }
        return this.registeredResolverFactories;
    }

    private void loadLists(String prefValue) {
        String[] resolvers = prefValue == null || prefValue.length() == 0 ? Trivial.EMPTY_STRING_ARRAY : prefValue.split(",");
        this.queryResolvers.setInput((Object)resolvers);
        this.queryResolvers.getList().select(0);
        this.queryResolversToAdd.setInput((Object)this.getPossibleResolverAdditions());
        this.enableDisableUpDownButtons(true);
    }

    private void moveItem(ListViewer from, ListViewer to) {
        List list = from.getList();
        int idx = list.getSelectionIndex();
        if (idx < 0) {
            return;
        }
        to.add((Object)list.getItem(idx));
        list.remove(idx);
        int top = list.getItemCount();
        if (idx >= top) {
            idx = top - 1;
        }
        if (idx >= 0) {
            list.select(idx);
        }
        this.enableDisableUpDownButtons(true);
    }
}

