/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.views;

import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.ui.providers.ResolutionsTreeContentProvider;
import org.eclipse.buckminster.ui.views.ComponentBrowserView;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.EditorPart;

public class ComponentOutlineView
extends ComponentBrowserView {
    private ISelectionListener selectionListener;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.hookPageSelection();
    }

    public void dispose() {
        if (this.selectionListener != null) {
            this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        }
        super.dispose();
    }

    public boolean isAutoExpand() {
        return true;
    }

    protected ResolutionsTreeContentProvider getContentProvider() {
        return new ResolutionsTreeContentProvider(ResolutionsTreeContentProvider.Mode.SINGLE);
    }

    private void hookPageSelection() {
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                ComponentOutlineView.this.pageSelectionChanged(part, selection);
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pageSelectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorInput input;
        if (part == this) {
            return;
        }
        IViewSite r = null;
        if (part instanceof EditorPart) {
            input = ((EditorPart)part).getEditorInput();
            IResource resource = (IResource)input.getAdapter(IResource.class);
            if (resource == null) return;
            r = (Resolution)resource.getAdapter(Resolution.class);
        } else {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (!sel.isEmpty() && sel.getFirstElement() instanceof IAdaptable) {
                IResource resource;
                IAdaptable element = (IAdaptable)sel.getFirstElement();
                r = (Resolution)element.getAdapter(Resolution.class);
                if (r == null && (resource = (IResource)element.getAdapter(IResource.class)) != null) {
                    resource = resource.getProject();
                    r = (Resolution)resource.getAdapter(Resolution.class);
                }
                if (r == null) {
                    IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
                    while (wbAdapter != null) {
                        IResource resource2 = null;
                        Object parent = wbAdapter.getParent((Object)element);
                        if (parent != null && parent instanceof IAdaptable) {
                            resource2 = (IResource)((IAdaptable)parent).getAdapter(IResource.class);
                        }
                        if (resource2 != null) {
                            r = (Resolution)resource2.getAdapter(Resolution.class);
                        }
                        if (r != null) break;
                        IWorkbenchAdapter iWorkbenchAdapter = wbAdapter = parent == null || !(parent instanceof IAdaptable) ? null : (IWorkbenchAdapter)((IAdaptable)parent).getAdapter(IWorkbenchAdapter.class);
                        if (wbAdapter == null) continue;
                        element = (IAdaptable)parent;
                    }
                }
            }
        }
        IViewSite iViewSite = input = r == null ? this.getViewSite() : r;
        if (this.viewer.getInput() == input) {
            return;
        }
        this.viewer.setInput((Object)input);
        this.viewer.expandAll();
    }
}

