/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.buckminster.ant.types.FileSetGroup;
import org.eclipse.buckminster.pde.ant.VersionConsolidatorTask;
import org.eclipse.buckminster.pde.tasks.FeatureConsolidator;

public class FeatureConsolidatorTask
extends VersionConsolidatorTask {
    private boolean generateVersionSuffix;
    private int maxVersionSuffixLength = -1;
    private int significantDigits = -1;
    private ArrayList<FileSet> fileSets;
    private ArrayList<FileSetGroup> fileSetGroups;

    public void add(FileSetGroup fsGroup) throws BuildException {
        if (this.fileSetGroups == null) {
            this.fileSetGroups = new ArrayList();
        }
        this.fileSetGroups.add(fsGroup);
    }

    public void addFileset(FileSet fs) throws BuildException {
        if (this.fileSets == null) {
            this.fileSets = new ArrayList();
        }
        this.fileSets.add(fs);
    }

    public void execute() throws BuildException {
        try {
            List featuresAndPlugins;
            if (this.fileSetGroups != null) {
                for (FileSetGroup fsg : this.fileSetGroups) {
                    for (FileSet fs : fsg.getFileSets()) {
                        this.addFileset(fs);
                    }
                }
                this.fileSetGroups = null;
            }
            if (this.getInput() == null) {
                throw new BuildException("Missing attribute input", this.getLocation());
            }
            if (this.getOutput() == null) {
                throw new BuildException("Missing attribute output", this.getLocation());
            }
            Project proj = this.getProject();
            if (this.fileSets == null) {
                featuresAndPlugins = Collections.emptyList();
            } else {
                featuresAndPlugins = new ArrayList();
                for (FileSet fs : this.fileSets) {
                    DirectoryScanner ds = fs.getDirectoryScanner(proj);
                    File dir = fs.getDir(proj);
                    for (String file : ds.getIncludedFiles()) {
                        featuresAndPlugins.add(new File(dir, file));
                    }
                }
            }
            FeatureConsolidator fc = new FeatureConsolidator(this.getInput(), this.getOutput(), this.getPropertiesFile(), featuresAndPlugins, this.getQualifier(), this.generateVersionSuffix, this.maxVersionSuffixLength, this.significantDigits);
            fc.run();
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    public void setGenerateVersionSuffix(boolean flag) {
        this.generateVersionSuffix = flag;
    }

    public void setMaxVersionSuffixLength(int len) {
        this.maxVersionSuffixLength = len;
    }

    public void setSignificantDigits(int count) {
        this.significantDigits = count;
    }
}

