/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.buckminster.pde.internal.ImportBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ImportBundleTask
extends Task {
    private URL siteURL;
    private File destdir;
    private String bundleName;

    public void execute() throws BuildException {
        try {
            if (this.bundleName == null) {
                throw this.missingAttribute("bundleName");
            }
            if (this.destdir == null) {
                throw this.missingAttribute("destdir");
            }
            if (this.siteURL == null) {
                throw this.missingAttribute("siteURL");
            }
            ImportBundle importBundle = new ImportBundle(this.bundleName, this.siteURL, (IPath)new Path(this.destdir.toString()));
            importBundle.execute();
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setDestdir(File destDir) {
        this.destdir = destDir;
    }

    public void setSiteDir(File siteDir) throws BuildException {
        try {
            this.siteURL = siteDir.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    public void setSiteURL(String siteURL) throws BuildException {
        try {
            this.siteURL = new URL(siteURL);
        }
        catch (MalformedURLException e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    protected BuildException missingAttribute(String property) {
        return new BuildException("Missing attribute \"" + property + '\"', this.getLocation());
    }
}

