/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.buckminster.ant.types.FileSetGroup;
import org.eclipse.buckminster.pde.tasks.SourceFeatureCreator;

public class SourceFeatureCreatorTask
extends Task {
    private NestedFileSets featuresAndBundles;
    private NestedFileSets translations;
    private File input;
    private File output;

    public void execute() throws BuildException {
        try {
            if (this.getInput() == null) {
                throw new BuildException("Missing attribute inputFile", this.getLocation());
            }
            if (this.getOutput() == null) {
                throw new BuildException("Missing attribute outputDir", this.getLocation());
            }
            Project proj = this.getProject();
            List<File> featuresAndPlugins = this.featuresAndBundles == null ? null : this.featuresAndBundles.getFiles(proj);
            List<File> translationFiles = this.translations == null ? null : this.translations.getFiles(proj);
            SourceFeatureCreator fc = new SourceFeatureCreator(this.getInput(), translationFiles, this.getOutput(), featuresAndPlugins);
            fc.run();
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    public File getInput() {
        return this.input;
    }

    public File getOutput() {
        return this.output;
    }

    public void setInputFile(File input) {
        this.input = input;
    }

    public void setOutputDir(File output) {
        this.output = output;
    }

    public NestedFileSets createFeaturesAndBundles() {
        this.featuresAndBundles = new NestedFileSets();
        return this.featuresAndBundles;
    }

    public NestedFileSets createTranslations() {
        this.translations = new NestedFileSets();
        return this.translations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NestedFileSets {
        private ArrayList<FileSet> fileSets;
        private ArrayList<FileSetGroup> fileSetGroups;

        public void add(FileSetGroup fsGroup) throws BuildException {
            if (this.fileSetGroups == null) {
                this.fileSetGroups = new ArrayList();
            }
            this.fileSetGroups.add(fsGroup);
        }

        public void addFileset(FileSet fs) throws BuildException {
            if (this.fileSets == null) {
                this.fileSets = new ArrayList();
            }
            this.fileSets.add(fs);
        }

        public List<File> getFiles(Project proj) {
            if (this.fileSetGroups != null) {
                for (FileSetGroup fsg : this.fileSetGroups) {
                    for (FileSet fs : fsg.getFileSets()) {
                        this.addFileset(fs);
                    }
                }
                this.fileSetGroups = null;
            }
            if (this.fileSets == null) {
                return Collections.emptyList();
            }
            ArrayList<File> files = new ArrayList<File>();
            for (FileSet fs : this.fileSets) {
                DirectoryScanner ds = fs.getDirectoryScanner(proj);
                File dir = fs.getDir(proj);
                for (String file : ds.getIncludedFiles()) {
                    files.add(new File(dir, file));
                }
            }
            return files;
        }
    }
}

