/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.buckminster.ant.types.FileSetGroup;
import org.eclipse.buckminster.pde.ant.VersionConsolidatorTask;
import org.eclipse.buckminster.pde.tasks.UpdateSiteGenerator;
import org.eclipse.equinox.p2.metadata.Version;

public class UpdateSiteGeneratorTask
extends VersionConsolidatorTask {
    private String versionProperty;
    private ArrayList<FileSet> fileSets;
    private ArrayList<FileSetGroup> fileSetGroups;

    public void add(FileSetGroup fsGroup) throws BuildException {
        if (this.fileSetGroups == null) {
            this.fileSetGroups = new ArrayList();
        }
        this.fileSetGroups.add(fsGroup);
    }

    public void addFileset(FileSet fs) throws BuildException {
        if (this.fileSets == null) {
            this.fileSets = new ArrayList();
        }
        this.fileSets.add(fs);
    }

    public void execute() throws BuildException {
        try {
            List features;
            if (this.fileSetGroups != null) {
                for (FileSetGroup fsg : this.fileSetGroups) {
                    for (FileSet fs : fsg.getFileSets()) {
                        this.addFileset(fs);
                    }
                }
                this.fileSetGroups = null;
            }
            Project proj = this.getProject();
            if (this.fileSets == null) {
                features = Collections.emptyList();
            } else {
                features = new ArrayList();
                for (FileSet fs : this.fileSets) {
                    DirectoryScanner ds = fs.getDirectoryScanner(proj);
                    File dir = fs.getDir(proj);
                    for (String file : ds.getIncludedFiles()) {
                        features.add(new File(dir, file));
                    }
                }
            }
            UpdateSiteGenerator generator = new UpdateSiteGenerator(features, this.getInput(), this.getOutput(), this.getPropertiesFile(), this.getQualifier());
            if (this.versionProperty != null) {
                Version version = generator.run(true);
                if (version != null) {
                    this.getProject().setUserProperty(this.versionProperty, version.toString());
                }
            } else {
                generator.run(false);
            }
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    public void setTemplate(String template) {
        if (template != null && template.length() == 0) {
            template = null;
        }
        this.setInputFile(new File(template));
    }

    public void setVersionProperty(String versionProperty) {
        this.versionProperty = versionProperty;
    }
}

