/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.internal.navigator.AdaptabilityUtility;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenFileAction openFileAction;
    private ICommonViewerWorkbenchSite viewSite = null;
    private boolean contribute = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(ICommonActionExtensionSite aConfig) {
        if (aConfig.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)aConfig.getViewSite();
            this.openFileAction = new OpenFileAction(this.viewSite.getPage());
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (!this.contribute || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openFileAction.selectionChanged(selection);
        if (this.openFileAction.isEnabled()) {
            aMenu.insertAfter("group.open", (IAction)this.openFileAction);
        }
        this.addOpenWithMenu(aMenu);
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (!this.contribute) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof IFile) {
            this.openFileAction.selectionChanged(selection);
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openFileAction);
        }
    }

    private void addOpenWithMenu(IMenuManager aMenu) {
        IAdaptable openable;
        IStructuredSelection ss = (IStructuredSelection)this.getContext().getSelection();
        if (ss == null || ss.size() != 1) {
            return;
        }
        Object o = ss.getFirstElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((openable = (IAdaptable)AdaptabilityUtility.getAdapter((Object)o, (Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            openable = (IAdaptable)AdaptabilityUtility.getAdapter((Object)o, (Class)clazz2);
        } else if (((IResource)openable).getType() != 1) {
            openable = null;
        }
        if (openable != null) {
            MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.OpenActionProvider_OpenWithMenu_label, "group.openWith");
            submenu.add((IContributionItem)new GroupMarker("group.top"));
            submenu.add((IContributionItem)new OpenWithMenu(this.viewSite.getPage(), openable));
            submenu.add((IContributionItem)new GroupMarker("additions"));
            if (submenu.getItems().length > 2 && submenu.isEnabled()) {
                aMenu.appendToGroup("group.openWith", (IContributionItem)submenu);
            }
        }
    }
}

