/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.io.IOException;
import java.io.OutputStream;

public class MultiTeeOutputStream
extends OutputStream {
    private final OutputStream[] streams;

    public MultiTeeOutputStream(OutputStream[] streams) {
        this.streams = streams;
    }

    public void close() throws IOException {
        IOException closeException = null;
        int idx = this.streams.length;
        while (--idx >= 0) {
            try {
                this.streams[idx].close();
            }
            catch (IOException ioe) {
                if (closeException != null) continue;
                closeException = ioe;
            }
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    public void flush() throws IOException {
        int idx = this.streams.length;
        while (--idx >= 0) {
            this.streams[idx].flush();
        }
    }

    public void write(byte[] b) throws IOException {
        int idx = this.streams.length;
        while (--idx >= 0) {
            this.streams[idx].write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int idx = this.streams.length;
        while (--idx >= 0) {
            this.streams[idx].write(b, off, len);
        }
    }

    public void write(int b) throws IOException {
        int idx = this.streams.length;
        while (--idx >= 0) {
            this.streams[idx].write(b);
        }
    }
}

