/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.build;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuckminsterBuilder
extends IncrementalProjectBuilder
implements IResourceChangeListener {
    public static final String ARG_REFRESH_RESOURCE = "refresh.resource";
    public static final String ARG_DERIVED_RESOURCE = "derived.resource";
    public static final String ARG_GIVEN_NAME_KEY = "given.name";
    public static final String ARG_DISABLED_KEY = "disabled";
    public static final String ARG_DELTA_RESOURCE_KEY = "delta.resource";
    public static final String ARG_AUTO_PRINTSTREAM_KEY = "auto.printstream";
    public static final String ARG_CLEAN_PRINTSTREAM_KEY = "clean.printstream";
    public static final String ARG_FULL_PRINTSTREAM_KEY = "full.printstream";
    public static final String ARG_INCREMENTAL_PRINTSTREAM_KEY = "incremental.printstream";
    private IConfigurationElement config;
    private Object data;
    private String propertyName;
    private PrintStream errStream = null;
    private PrintStream outStream = null;
    private IResource[] notifyOnChangedResources;
    private boolean initialBuildDone = false;

    public static String bestNameForBuilder(String givenName, IConfigurationElement ce) {
        String s;
        StringBuilder sb = new StringBuilder();
        if (givenName != null) {
            sb.append(givenName).append(" (");
        }
        if ((s = ce.getDeclaringExtension().getLabel().trim()).length() == 0) {
            s = ce.getDeclaringExtension().getUniqueIdentifier();
        }
        sb.append(s);
        if (givenName != null) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getValue(Map<String, String> args, String key) {
        String v = args.get(key);
        if (v != null && (v = v.trim()).length() == 0) {
            v = null;
        }
        return v;
    }

    public static boolean isDeltaMatching(Map<String, String> args, IProject project, IResourceDelta delta, IResource[] notifyOnChangedResources) throws CoreException {
        if (delta == null) {
            return true;
        }
        String deltaResource = AbstractBuckminsterBuilder.getValue(args, ARG_DELTA_RESOURCE_KEY);
        if (deltaResource == null) {
            return true;
        }
        if (delta.findMember((IPath)new Path(deltaResource)) != null) {
            return true;
        }
        if (notifyOnChangedResources != null) {
            IResource[] iResourceArray = notifyOnChangedResources;
            int n = notifyOnChangedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (delta.findMember(r.getFullPath()) != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isDisabled(Map<String, String> args) {
        return Boolean.parseBoolean(AbstractBuckminsterBuilder.getValue(args, ARG_DISABLED_KEY));
    }

    public static boolean isPrintingEnabledForKind(Map<String, String> args, int kind) {
        String key = null;
        switch (kind) {
            case 9: {
                key = ARG_AUTO_PRINTSTREAM_KEY;
                break;
            }
            case 15: {
                key = ARG_CLEAN_PRINTSTREAM_KEY;
                break;
            }
            case 6: {
                key = ARG_FULL_PRINTSTREAM_KEY;
                break;
            }
            case 10: {
                key = ARG_INCREMENTAL_PRINTSTREAM_KEY;
            }
        }
        if (key == null) {
            return true;
        }
        String value = AbstractBuckminsterBuilder.getValue(args, key);
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public static String kindToString(int kind) {
        if (kind == 9) {
            return "AUTO";
        }
        if (kind == 15) {
            return "CLEAN";
        }
        if (kind == 6) {
            return "FULL";
        }
        if (kind == 10) {
            return "INCREMENTAL";
        }
        return "NONE";
    }

    public static void setDisabled(Map<String, String> args, boolean disabled) {
        if (disabled) {
            args.put(ARG_DISABLED_KEY, Boolean.TRUE.toString());
        } else {
            args.remove(ARG_DISABLED_KEY);
        }
    }

    public static void setPrintingEnabledForKind(Map<String, String> args, int kind, boolean enabled) {
        String key = null;
        switch (kind) {
            case 9: {
                key = ARG_AUTO_PRINTSTREAM_KEY;
                break;
            }
            case 15: {
                key = ARG_CLEAN_PRINTSTREAM_KEY;
                break;
            }
            case 6: {
                key = ARG_FULL_PRINTSTREAM_KEY;
                break;
            }
            case 10: {
                key = ARG_INCREMENTAL_PRINTSTREAM_KEY;
            }
        }
        if (key != null) {
            if (enabled) {
                args.remove(key);
            } else {
                args.put(key, Boolean.FALSE.toString());
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.notifyOnChangedResources != null && event.getType() == 1) {
            ArrayList<IResource> changedResources = null;
            IResource[] iResourceArray = this.notifyOnChangedResources;
            int n = this.notifyOnChangedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                IResourceDelta delta = event.getDelta().findMember(r.getFullPath());
                if (delta != null) {
                    if (changedResources == null) {
                        changedResources = new ArrayList<IResource>();
                    }
                    changedResources.add(r);
                }
                ++n2;
            }
            if (changedResources != null) {
                this.resourcesChangeNotification(changedResources.toArray(new IResource[0]));
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        this.config = config;
        this.propertyName = propertyName;
        this.data = data;
    }

    protected final IProject[] build(int kind, Map rawArgs, IProgressMonitor monitor) throws CoreException {
        boolean isDeltaMatching;
        boolean disabled;
        HashMap<String, String> args = rawArgs;
        if (args == null) {
            args = new HashMap<String, String>();
        }
        if (disabled = AbstractBuckminsterBuilder.isDisabled((Map<String, String>)args)) {
            return null;
        }
        boolean bl = isDeltaMatching = kind != 9 && kind != 10 ? true : AbstractBuckminsterBuilder.isDeltaMatching(args, this.getProject(), this.getDelta(this.getProject()), this.notifyOnChangedResources);
        if (!isDeltaMatching && this.initialBuildDone) {
            return null;
        }
        IProject[] projects = null;
        this.initialBuildDone = true;
        boolean needsPrintStream = AbstractBuckminsterBuilder.isPrintingEnabledForKind(args, kind);
        MonitorUtils.begin((IProgressMonitor)monitor, (int)10);
        Logger logger = CorePlugin.getLogger();
        try {
            IResource resource;
            String derivedResource;
            IResource resource2;
            if (needsPrintStream) {
                this.outStream = Logger.getOutStream();
                this.errStream = Logger.getErrStream();
            } else {
                this.outStream = System.out;
                this.errStream = System.err;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[start AntBuilder(%s)] : %s - %s", new Object[]{AbstractBuckminsterBuilder.kindToString(kind), this.getBestName(args), this.getProject().getName()});
            }
            projects = this.doBuild(kind, args, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)8));
            String refreshResource = AbstractBuckminsterBuilder.getValue(args, ARG_REFRESH_RESOURCE);
            if (refreshResource != null && (resource2 = this.getProject().findMember((IPath)new Path(refreshResource))) != null) {
                resource2.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            }
            if ((derivedResource = AbstractBuckminsterBuilder.getValue(args, ARG_DERIVED_RESOURCE)) != null && (resource = this.getProject().findMember((IPath)new Path(derivedResource))) != null) {
                if (refreshResource == null || !refreshResource.equals(derivedResource)) {
                    resource.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
                resource.setDerived(true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            }
        }
        catch (Throwable throwable) {
            MonitorUtils.done((IProgressMonitor)monitor);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("[end AntBuilder(%s)]", AbstractBuckminsterBuilder.kindToString(kind)), new Object[0]);
            }
            throw throwable;
        }
        MonitorUtils.done((IProgressMonitor)monitor);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("[end AntBuilder(%s)]", AbstractBuckminsterBuilder.kindToString(kind)), new Object[0]);
        }
        return projects;
    }

    protected final void clean(IProgressMonitor monitor) throws CoreException {
        this.build(15, this.getCommand().getArguments(), monitor);
    }

    protected IProject[] doAutoBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    protected IProject[] doBuild(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 9) {
            return this.doAutoBuild(args, monitor);
        }
        if (kind == 15) {
            return this.doCleanBuild(args, monitor);
        }
        if (kind == 6) {
            return this.doFullBuild(args, monitor);
        }
        if (kind == 10) {
            return this.doIncrementalBuild(args, monitor);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.buckminster.core", 0, Messages.Unknown_kind, null));
    }

    protected IProject[] doCleanBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    protected IProject[] doFullBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    protected IProject[] doIncrementalBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    protected void doStartupOnInitialize() {
    }

    protected String getBestName(Map<String, String> args) {
        return AbstractBuckminsterBuilder.bestNameForBuilder(this.getGivenName(args), this.config);
    }

    protected IConfigurationElement getConfig() {
        return this.config;
    }

    protected Object getData() {
        return this.data;
    }

    protected PrintStream getErrStream() {
        return this.errStream;
    }

    protected String getGivenName(Map<String, String> args) {
        return AbstractBuckminsterBuilder.getValue(args, ARG_GIVEN_NAME_KEY);
    }

    protected PrintStream getOutStream() {
        return this.outStream;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected void notifyOnChangedResources(IResource[] resources) {
        this.notifyOnChangedResources = resources;
    }

    protected void resourcesChangeNotification(IResource[] changedResources) {
        throw new IllegalStateException(Messages.Method_not_overridden);
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.doStartupOnInitialize();
    }
}

