/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.core.commands.Launch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundLaunch
extends Launch {
    private static final OptionDescriptor IGNORE_MISSING = new OptionDescriptor('I', "ignoremissing", 2);
    private boolean ignoreMissing = false;

    @Override
    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(IGNORE_MISSING);
        super.getOptionDescriptors(appendHere);
    }

    @Override
    protected void handleOption(Option option) throws Exception {
        super.handleOption(option);
        if (option.is(IGNORE_MISSING)) {
            this.ignoreMissing = true;
        }
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        if (this.ignoreMissing) {
            String launchName = this.getLaunchName();
            if (launchName == null) {
                return 0;
            }
            IResource launchFile = ResourcesPlugin.getWorkspace().getRoot().findMember(launchName);
            if (launchFile == null || launchFile.getType() != 1 || !launchFile.exists()) {
                return 0;
            }
        }
        this.setBackground(true);
        return super.internalRun(monitor);
    }
}

