/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceMappingManager {
    private static final String PREFMAPPINGS_EXTPOINT = "org.eclipse.buckminster.cmdline.prefmappings";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String TEST_PREFIX = "org.eclipse.buckminster.cmdline.test.";
    private static WeakReference<PreferenceMappingManager> instanceRef;
    private final boolean includeTests;
    private final List<BasicPreferenceHandler> mappings;

    public static synchronized PreferenceMappingManager getInstance(boolean includeTests) throws CoreException {
        PreferenceMappingManager pmm = null;
        if (instanceRef != null) {
            pmm = (PreferenceMappingManager)instanceRef.get();
        }
        if (pmm == null || pmm.includeTests != includeTests) {
            pmm = new PreferenceMappingManager(includeTests);
            instanceRef = new WeakReference<PreferenceMappingManager>(pmm);
        }
        return pmm;
    }

    private PreferenceMappingManager(boolean includeTests) throws CoreException {
        this.includeTests = includeTests;
        this.mappings = this.findAllMappings();
    }

    public List<BasicPreferenceHandler> getAllHandlers(String pattern) {
        Pattern rx = pattern == null ? null : Pattern.compile(pattern);
        ArrayList<BasicPreferenceHandler> handlers = new ArrayList<BasicPreferenceHandler>();
        int top = this.mappings.size();
        int idx = 0;
        while (idx < top) {
            BasicPreferenceHandler bph = this.mappings.get(idx);
            if (rx == null || rx.matcher(bph.getName()).find()) {
                handlers.add(bph);
            }
            ++idx;
        }
        Comparator<BasicPreferenceHandler> bphComparator = new Comparator<BasicPreferenceHandler>(){

            @Override
            public int compare(BasicPreferenceHandler o1, BasicPreferenceHandler o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(handlers, bphComparator);
        return handlers;
    }

    public BasicPreferenceHandler getHandler(String name) throws UsageException {
        ArrayList<BasicPreferenceHandler> matches = null;
        int idx = this.mappings.size();
        block0: while (--idx >= 0) {
            BasicPreferenceHandler mapping = this.mappings.get(idx);
            String prefName = mapping.getName();
            while (true) {
                if (name.equals(prefName)) {
                    if (matches == null) {
                        matches = new ArrayList<BasicPreferenceHandler>();
                    }
                    matches.add(mapping);
                    continue block0;
                }
                int dotIdx = prefName.indexOf(46);
                if (dotIdx < 0) continue block0;
                prefName = prefName.substring(dotIdx + 1);
            }
        }
        if (matches == null) {
            throw new UsageException(NLS.bind((String)Messages.No_preference_matches_0, (Object)name));
        }
        int foundMatches = matches.size();
        if (foundMatches == 1) {
            return (BasicPreferenceHandler)matches.get(0);
        }
        StringBuilder bld = new StringBuilder(80);
        bld.append(NLS.bind((String)Messages.Preference_0_is_ambiguous, (Object)name));
        int i = 0;
        while (i < foundMatches) {
            if (i > 0) {
                bld.append(", ");
                if (i + 1 == foundMatches) {
                    bld.append(Messages.And);
                }
            }
            bld.append(((BasicPreferenceHandler)matches.get(i)).getName());
            ++i;
        }
        throw new UsageException(bld.toString());
    }

    private List<BasicPreferenceHandler> findAllMappings() throws CoreException {
        ArrayList<BasicPreferenceHandler> prefMappings = new ArrayList<BasicPreferenceHandler>();
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = er.getConfigurationElementsFor(PREFMAPPINGS_EXTPOINT);
        int idx = elems.length;
        while (--idx >= 0) {
            BasicPreferenceHandler bph;
            IConfigurationElement elem = elems[idx];
            if (elem.getAttribute(CLASS_ATTRIBUTE) != null) {
                bph = (BasicPreferenceHandler)elem.createExecutableExtension(CLASS_ATTRIBUTE);
            } else {
                bph = new BasicPreferenceHandler();
                bph.setInitializationData(elem, CLASS_ATTRIBUTE, null);
            }
            String name = bph.getName();
            if (name.startsWith(TEST_PREFIX) && !this.includeTests) continue;
            prefMappings.add(bph);
        }
        return prefMappings;
    }
}

