/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.PreferenceMappingManager;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPreference
extends WorkspaceCommand {
    private static final OptionDescriptor TEST_DESCRIPTOR = new OptionDescriptor(null, "__test", 1);
    private boolean test = false;
    private String[] assignments;

    public static void set(String preference, String value) throws Exception {
        SetPreference setpref = new SetPreference();
        setpref.handleUnparsed(new String[]{String.valueOf(preference) + '=' + value});
        setpref.run("setpref");
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(TEST_DESCRIPTOR);
        super.getOptionDescriptors(appendHere);
    }

    protected void handleOption(Option option) throws Exception {
        this.test = option.is(TEST_DESCRIPTOR);
        super.handleOption(option);
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length < 1) {
            throw new UsageException(Messages.You_must_provide_at_least_one_preference_assignment);
        }
        this.assignments = unparsed;
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        PreferenceMappingManager prefManager = PreferenceMappingManager.getInstance(this.test);
        int idx = 0;
        while (idx < this.assignments.length) {
            String assignment = this.assignments[idx];
            int eqIdx = assignment.indexOf(61);
            if (eqIdx < 1 || eqIdx >= assignment.length() - 1) {
                throw new UsageException(NLS.bind((String)Messages._0_is_not_an_assignment, (Object)assignment));
            }
            String key = assignment.substring(0, eqIdx);
            String value = assignment.substring(eqIdx + 1);
            prefManager.getHandler(key).set(value);
            CorePlugin.getLogger().debug("Preference '%s' set to the value '%s'", new Object[]{key, value});
            ++idx;
        }
        return 0;
    }
}

