/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.ValueHolderFilter;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSplit
extends ValueHolderFilter {
    public static final String TAG = "split";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_PATTERN = "pattern";
    private final Pattern pattern;

    AbstractSplit(String splitter) {
        this.pattern = Pattern.compile(splitter);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.pattern.equals(((AbstractSplit)((Object)o)).pattern);
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc = 37 * hc + this.pattern.hashCode();
        return hc;
    }

    @Override
    public boolean isMultiValueProducer() {
        return true;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PATTERN, (String)this.pattern.toString());
    }

    @Override
    protected String checkedGetValue(Map<String, ? extends Object> properties, int recursionGuard) {
        List values = this.checkedGetValues(properties, recursionGuard);
        int top = values.size();
        if (top == 0) {
            return "";
        }
        if (top == 1) {
            return (String)values.get(0);
        }
        StringBuilder bld = new StringBuilder();
        int idx = 0;
        while (idx < top) {
            bld.append((String)values.get(idx));
            ++idx;
        }
        return bld.toString();
    }

    final Pattern getPattern() {
        return this.pattern;
    }
}

