/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentIdentifier
extends ComponentName
implements IComponentIdentifier {
    private final Version version;
    public static final String ATTR_VERSION_TYPE = "versionType";
    public static final String ATTR_VERSION = "version";

    public static ComponentIdentifier parse(String componentIdentifierStr) throws CoreException {
        Version version = null;
        int verIdx = componentIdentifierStr.indexOf(36);
        if (verIdx >= 0) {
            String versionStr = componentIdentifierStr.substring(verIdx + 1);
            componentIdentifierStr = componentIdentifierStr.substring(0, verIdx);
            String versionType = null;
            int typeIdx = versionStr.indexOf(35);
            if (typeIdx > 0) {
                versionType = versionStr.substring(typeIdx + 1);
                versionStr = versionStr.substring(0, typeIdx);
                version = VersionHelper.createVersion(versionType, versionStr);
            } else {
                version = VersionHelper.parseVersion(versionStr);
            }
        }
        String componentType = null;
        int catIdx = componentIdentifierStr.indexOf(58);
        if (catIdx >= 0) {
            componentType = componentIdentifierStr.substring(catIdx + 1);
            componentIdentifierStr = componentIdentifierStr.substring(0, catIdx);
        }
        return new ComponentIdentifier(componentIdentifierStr, componentType, version);
    }

    public ComponentIdentifier(String name, String componentTypeID, Version version) {
        super(name, componentTypeID);
        this.version = version;
    }

    @Override
    public int compareTo(IComponentName o) {
        int cmp = Trivial.compareAllowNull((Comparable)((Object)this.getName()), (Comparable)((Object)o.getName()));
        if (cmp == 0) {
            int n = cmp = o instanceof IComponentIdentifier ? Trivial.compareAllowNull((Comparable)this.version, (Comparable)((IComponentIdentifier)o).getVersion()) : 1;
            if (cmp == 0) {
                cmp = Trivial.compareAllowNull((Comparable)((Object)this.getComponentTypeID()), (Comparable)((Object)o.getComponentTypeID()));
            }
        }
        return cmp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this == o || super.equals(o) && Trivial.equalsAllowNull((Object)this.version, (Object)((ComponentIdentifier)o).version);
    }

    @Override
    public String getDefaultTag() {
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> p = super.getProperties();
        if (this.version != null) {
            p.put("buckminster.version", this.version.toString());
        }
        return p;
    }

    @Override
    public final Version getVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        if (this.version != null) {
            hc *= 37;
            hc += this.version.hashCode();
        }
        return hc;
    }

    public boolean matches(ComponentIdentifier o) {
        return super.matches(o) && (this.version == null || o.version == null || this.version.equals(o.version));
    }

    @Override
    public ComponentName toPureComponentName() {
        return new ComponentName(this);
    }

    @Override
    public void toString(StringBuilder bld) {
        super.toString(bld);
        if (this.version != null) {
            bld.append('$');
            bld.append(VersionHelper.getHumanReadable(this.version));
        }
    }
}

