/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.materializer.AbstractMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.MetadataSynchronizer;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class InstallerJob
extends WorkspaceJob {
    private final MaterializationContext context;
    private final boolean propagateStatus;

    public InstallerJob(MaterializationContext ctx, boolean propagateStatus) throws CoreException {
        super(Messages.InstallerJob_Installing);
        this.context = ctx;
        this.propagateStatus = propagateStatus;
        this.setSystem(false);
        this.setUser(true);
        this.setPriority(40);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 1000);
        BillOfMaterials bom = this.context.getBillOfMaterials();
        try {
            try {
                AbstractMaterializer.performInstallActions(bom, this.context, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                MetadataSynchronizer.workspaceCatchUp(monitor);
            }
            catch (CoreException e) {
                this.context.addRequestStatus(bom.getRequest(), e.getStatus());
                if (this.propagateStatus) {
                    CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
                }
                monitor.done();
                if (this.propagateStatus) {
                    this.context.emitWarningAndErrorTags();
                }
            }
        }
        finally {
            monitor.done();
            if (this.propagateStatus) {
                this.context.emitWarningAndErrorTags();
            }
        }
        return Status.OK_STATUS;
    }
}

