/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.materializer.IMaterializer;
import org.eclipse.buckminster.core.materializer.InstallerJob;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.MaterializerJob;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializationJob
extends Job {
    public static final String MAX_PARALLEL_JOBS = "maxParallelMaterializationJobs";
    public static final int MAX_PARALLEL_JOBS_DEFAULT = 4;
    private final MaterializationContext context;

    public static int getMaxParallelJobs() {
        return BuckminsterPreferences.getNode().getInt(MAX_PARALLEL_JOBS, 4);
    }

    public static void run(MaterializationContext context) throws CoreException {
        try {
            MaterializationJob mbJob = new MaterializationJob(context);
            mbJob.schedule();
            mbJob.join();
            IStatus status = mbJob.getResult();
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            throw BuckminsterException.wrap((Throwable)t);
        }
    }

    public static void runDelegated(MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        MaterializationJob mbJob = new MaterializationJob(context);
        mbJob.internalRun(monitor, false);
    }

    public static void setMaxParallelJobs(int maxJobs) {
        if (maxJobs > 0 && maxJobs <= 20) {
            BuckminsterPreferences.getNode().putInt(MAX_PARALLEL_JOBS, maxJobs);
        }
    }

    public static void setUp() {
        IEclipsePreferences defaultNode = BuckminsterPreferences.getDefaultNode();
        defaultNode.putInt(MAX_PARALLEL_JOBS, 4);
        try {
            defaultNode.flush();
        }
        catch (BackingStoreException e) {
            Buckminster.getLogger().error((Throwable)e, e.toString(), new Object[0]);
        }
    }

    public MaterializationJob(MaterializationContext ctx) {
        super(Messages.Materializing);
        this.context = ctx;
        this.setSystem(false);
        this.setUser(false);
        this.setPriority(30);
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            this.internalRun(monitor, true);
        }
        catch (CoreException e) {
            CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        this.context.emitWarningAndErrorTags();
        return Status.OK_STATUS;
    }

    protected MaterializationContext getMaterializationContext() {
        return this.context;
    }

    protected void internalRun(IProgressMonitor monitor, boolean waitForCompletion) throws CoreException {
        BillOfMaterials bom = this.context.getBillOfMaterials();
        Queue<MaterializerJob> allJobs = this.prepareJobs(monitor, bom);
        if (allJobs != null) {
            this.triggerJobs(monitor, allJobs);
            this.waitForJobs(monitor, allJobs, bom);
        }
        if (this.context.getStatus().getSeverity() == 4) {
            throw BuckminsterException.wrap((IStatus)this.context.getStatus());
        }
        InstallerJob installerJob = new InstallerJob(this.context, !waitForCompletion);
        installerJob.schedule();
        if (waitForCompletion) {
            try {
                installerJob.join();
            }
            catch (InterruptedException e) {
                throw new OperationCanceledException();
            }
        }
    }

    protected Queue<MaterializerJob> prepareJobs(IProgressMonitor monitor, BillOfMaterials bom) throws CoreException {
        CorePlugin corePlugin = CorePlugin.getDefault();
        LinkedHashMap<String, ArrayList<Resolution>> resPerMat = new LinkedHashMap<String, ArrayList<Resolution>>();
        MaterializationSpec mspec = this.context.getMaterializationSpec();
        for (Resolution cr : bom.findMaterializationCandidates(this.context, mspec)) {
            String materializer = mspec.getMaterializerID(cr);
            ArrayList<Resolution> crs = (ArrayList<Resolution>)resPerMat.get(materializer);
            if (crs == null) {
                crs = new ArrayList<Resolution>();
                resPerMat.put(materializer, crs);
            }
            crs.add(cr);
        }
        if (resPerMat.size() == 0) {
            return null;
        }
        ConcurrentLinkedQueue<MaterializerJob> allJobs = new ConcurrentLinkedQueue<MaterializerJob>();
        for (Map.Entry entry : resPerMat.entrySet()) {
            IMaterializer materializer = corePlugin.getMaterializer((String)entry.getKey());
            List resolutions = (List)entry.getValue();
            if (materializer.canWorkInParallel()) {
                for (Resolution res : resolutions) {
                    allJobs.offer(new MaterializerJob((String)entry.getKey(), materializer, Collections.singletonList(res), this.context));
                }
                continue;
            }
            allJobs.offer(new MaterializerJob((String)entry.getKey(), materializer, resolutions, this.context));
        }
        return allJobs;
    }

    protected void triggerJobs(final IProgressMonitor monitor, final Queue<MaterializerJob> allJobs) {
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                if (monitor.isCanceled() || !MaterializationJob.this.context.isContinueOnError() && MaterializationJob.this.context.getStatus().getSeverity() == 4) {
                    MaterializationJob.this.cancel();
                }
            }

            public void done(IJobChangeEvent event) {
                MaterializerJob mjob;
                if (!monitor.isCanceled() && (mjob = (MaterializerJob)allJobs.poll()) != null) {
                    mjob.addJobChangeListener((IJobChangeListener)this);
                    mjob.schedule();
                }
            }
        };
        int maxJobs = this.context.getMaxParallelJobs();
        int idx = 0;
        while (idx < maxJobs) {
            MaterializerJob job = allJobs.poll();
            if (job == null) break;
            job.addJobChangeListener((IJobChangeListener)listener);
            job.schedule();
            ++idx;
        }
    }

    protected void waitForJobs(IProgressMonitor monitor, Queue<MaterializerJob> allJobs, BillOfMaterials bom) throws CoreException {
        IJobManager jobManager = Job.getJobManager();
        try {
            jobManager.join((Object)this.context, monitor);
        }
        catch (OperationCanceledException e) {
            jobManager.cancel((Object)this.context);
            allJobs.clear();
            throw e;
        }
        catch (InterruptedException e) {
            jobManager.cancel((Object)this.context);
            allJobs.clear();
            throw new OperationCanceledException();
        }
    }
}

